/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.symbol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.symbol.Decorator;
import org.elasticsearch.painless.symbol.FunctionTable;

public class ScriptScope
extends Decorator {
    protected final PainlessLookup painlessLookup;
    protected final CompilerSettings compilerSettings;
    protected final ScriptClassInfo scriptClassInfo;
    protected final String scriptName;
    protected final String scriptSource;
    protected final FunctionTable functionTable = new FunctionTable();
    protected int syntheticCounter = 0;
    protected boolean deterministic = true;
    protected Set<String> usedVariables = Collections.emptySet();
    protected Map<String, Object> staticConstants = new HashMap<String, Object>();

    public ScriptScope(PainlessLookup painlessLookup, CompilerSettings compilerSettings, ScriptClassInfo scriptClassInfo, String scriptName, String scriptSource, int nodeCount) {
        super(nodeCount);
        this.painlessLookup = Objects.requireNonNull(painlessLookup);
        this.compilerSettings = Objects.requireNonNull(compilerSettings);
        this.scriptClassInfo = Objects.requireNonNull(scriptClassInfo);
        this.scriptName = Objects.requireNonNull(scriptName);
        this.scriptSource = Objects.requireNonNull(scriptSource);
        this.staticConstants.put("$NAME", scriptName);
        this.staticConstants.put("$SOURCE", scriptSource);
        this.staticConstants.put("$DEFINITION", painlessLookup);
        this.staticConstants.put("$FUNCTIONS", this.functionTable);
        this.staticConstants.put("$COMPILERSETTINGS", compilerSettings.asMap());
    }

    public PainlessLookup getPainlessLookup() {
        return this.painlessLookup;
    }

    public CompilerSettings getCompilerSettings() {
        return this.compilerSettings;
    }

    public ScriptClassInfo getScriptClassInfo() {
        return this.scriptClassInfo;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getScriptSource() {
        return this.scriptSource;
    }

    public FunctionTable getFunctionTable() {
        return this.functionTable;
    }

    public String getNextSyntheticName(String prefix) {
        return prefix + "$synthetic$" + this.syntheticCounter++;
    }

    public void markNonDeterministic(boolean nondeterministic) {
        this.deterministic &= !nondeterministic;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setUsedVariables(Set<String> usedVariables) {
        this.usedVariables = usedVariables;
    }

    public Set<String> getUsedVariables() {
        return Collections.unmodifiableSet(this.usedVariables);
    }

    public void addStaticConstant(String name, Object constant) {
        this.staticConstants.put(name, constant);
    }

    public Map<String, Object> getStaticConstants() {
        return Collections.unmodifiableMap(this.staticConstants);
    }

    public <T extends Decorator.Decoration> T putDecoration(ANode node, T decoration) {
        return this.put(node.getIdentifier(), decoration);
    }

    public <T extends Decorator.Decoration> T removeDecoration(ANode node, Class<T> type) {
        return this.remove(node.getIdentifier(), type);
    }

    public <T extends Decorator.Decoration> T getDecoration(ANode node, Class<T> type) {
        return this.get(node.getIdentifier(), type);
    }

    public boolean hasDecoration(ANode node, Class<? extends Decorator.Decoration> type) {
        return this.has(node.getIdentifier(), type);
    }

    public <T extends Decorator.Decoration> boolean copyDecoration(ANode originalNode, ANode targetNode, Class<T> type) {
        return this.copy(originalNode.getIdentifier(), targetNode.getIdentifier(), type);
    }

    public boolean setCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.set(node.getIdentifier(), type);
    }

    public boolean deleteCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.delete(node.getIdentifier(), type);
    }

    public boolean getCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.exists(node.getIdentifier(), type);
    }

    public boolean replicateCondition(ANode originalNode, ANode targetNode, Class<? extends Decorator.Condition> type) {
        return this.replicate(originalNode.getIdentifier(), targetNode.getIdentifier(), type);
    }
}

