/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.core.Strings;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.objectweb.asm.Type;

public class FunctionRef {
    public final String interfaceMethodName;
    public final MethodType interfaceMethodType;
    public final String delegateClassName;
    public final boolean isDelegateInterface;
    public final boolean isDelegateAugmented;
    public final int delegateInvokeType;
    public final String delegateMethodName;
    public final MethodType delegateMethodType;
    public final Object[] delegateInjections;
    private final MethodType factoryMethodType;
    public final Type factoryMethodReceiver;

    public static FunctionRef create(PainlessLookup painlessLookup, FunctionTable functionTable, Location location, Class<?> targetClass, String typeName, String methodName, int numberOfCaptures, Map<String, Object> constants, boolean needsScriptInstance) {
        Objects.requireNonNull(painlessLookup);
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(typeName);
        Objects.requireNonNull(methodName);
        String targetClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        try {
            List<Class<?>> delegateMethodParameters;
            Class<?> delegateMethodReturnType;
            Object[] delegateInjections;
            MethodType delegateMethodType;
            String delegateMethodName;
            int delegateInvokeType;
            boolean isDelegateAugmented;
            boolean isDelegateInterface;
            String delegateClassName;
            PainlessMethod interfaceMethod = painlessLookup.lookupFunctionalInterfacePainlessMethod(targetClass);
            if (interfaceMethod == null) {
                throw new IllegalArgumentException(Strings.format("cannot convert function reference [%s::%s] to a non-functional interface [%s]", typeName, methodName, targetClassName));
            }
            String interfaceMethodName = interfaceMethod.javaMethod().getName();
            MethodType interfaceMethodType = interfaceMethod.methodType().dropParameterTypes(0, 1);
            int interfaceTypeParametersSize = interfaceMethod.typeParameters().size();
            if ("this".equals(typeName)) {
                Objects.requireNonNull(functionTable);
                if (numberOfCaptures < 0) {
                    throw new IllegalStateException("internal error");
                }
                String localFunctionKey = FunctionTable.buildLocalFunctionKey(methodName, numberOfCaptures + interfaceTypeParametersSize);
                FunctionTable.LocalFunction localFunction = functionTable.getFunction(localFunctionKey);
                if (localFunction == null) {
                    throw new IllegalArgumentException(Strings.format("function reference [this::%s] matching [%s, %s/%d] not found%s", localFunctionKey, targetClassName, interfaceMethodName, interfaceTypeParametersSize, localFunctionKey.contains("$") ? " due to an incorrect number of arguments" : ""));
                }
                delegateClassName = WriterConstants.CLASS_NAME;
                isDelegateInterface = false;
                isDelegateAugmented = false;
                delegateInvokeType = needsScriptInstance ? 5 : 6;
                delegateMethodName = localFunction.getMangledName();
                delegateMethodType = localFunction.getMethodType();
                delegateInjections = new Object[]{};
                delegateMethodReturnType = localFunction.getReturnType();
                delegateMethodParameters = localFunction.getTypeParameters();
            } else if ("new".equals(methodName)) {
                if (numberOfCaptures != 0) {
                    throw new IllegalStateException("internal error");
                }
                PainlessConstructor painlessConstructor = painlessLookup.lookupPainlessConstructor(typeName, interfaceTypeParametersSize);
                if (painlessConstructor == null) {
                    throw new IllegalArgumentException(Strings.format("function reference [%s::new/%d] matching [%s, %s/%d] not found", typeName, interfaceTypeParametersSize, targetClassName, interfaceMethodName, interfaceTypeParametersSize));
                }
                delegateClassName = painlessConstructor.javaConstructor().getDeclaringClass().getName();
                isDelegateInterface = false;
                isDelegateAugmented = false;
                delegateInvokeType = 8;
                delegateMethodName = "<init>";
                delegateMethodType = painlessConstructor.methodType();
                delegateInjections = new Object[]{};
                delegateMethodReturnType = painlessConstructor.javaConstructor().getDeclaringClass();
                delegateMethodParameters = painlessConstructor.typeParameters();
            } else {
                if (numberOfCaptures != 0 && numberOfCaptures != 1) {
                    throw new IllegalStateException("internal error");
                }
                boolean captured = numberOfCaptures == 1;
                PainlessMethod painlessMethod = painlessLookup.lookupPainlessMethod(typeName, true, methodName, interfaceTypeParametersSize);
                if (painlessMethod == null) {
                    painlessMethod = painlessLookup.lookupPainlessMethod(typeName, false, methodName, captured ? interfaceTypeParametersSize : interfaceTypeParametersSize - 1);
                    if (painlessMethod == null) {
                        throw new IllegalArgumentException(Strings.format("function reference [%s::%s/%d] matching [%s, %s/%d] not found", typeName, methodName, interfaceTypeParametersSize, targetClassName, interfaceMethodName, interfaceTypeParametersSize));
                    }
                } else if (captured) {
                    throw new IllegalArgumentException(Strings.format("cannot use a static method as a function reference [%s::%s/%d] with a non-static captured variable", typeName, methodName, interfaceTypeParametersSize));
                }
                delegateClassName = painlessMethod.javaMethod().getDeclaringClass().getName();
                isDelegateInterface = painlessMethod.javaMethod().getDeclaringClass().isInterface();
                boolean bl = isDelegateAugmented = painlessMethod.javaMethod().getDeclaringClass() != painlessMethod.targetClass();
                delegateInvokeType = Modifier.isStatic(painlessMethod.javaMethod().getModifiers()) ? 6 : (isDelegateInterface ? 9 : 5);
                delegateMethodName = painlessMethod.javaMethod().getName();
                delegateMethodType = painlessMethod.methodType();
                if (delegateInvokeType != 6 && painlessMethod.javaMethod().getDeclaringClass() != painlessMethod.methodType().parameterType(0)) {
                    if (painlessMethod.methodType().parameterType(0) != Object.class) {
                        throw new IllegalStateException("internal error");
                    }
                    delegateMethodType = delegateMethodType.changeParameterType(0, painlessMethod.javaMethod().getDeclaringClass());
                }
                delegateInjections = PainlessLookupUtility.buildInjections(painlessMethod, constants);
                delegateMethodReturnType = painlessMethod.returnType();
                if (delegateMethodType.parameterList().size() > painlessMethod.typeParameters().size()) {
                    delegateMethodParameters = new ArrayList(painlessMethod.typeParameters());
                    delegateMethodParameters.add(0, (Class<?>)delegateMethodType.parameterType(0));
                } else {
                    delegateMethodParameters = painlessMethod.typeParameters();
                }
            }
            if (location != null) {
                for (int typeParameter = 0; typeParameter < interfaceTypeParametersSize; ++typeParameter) {
                    Class<?> from = interfaceMethod.typeParameters().get(typeParameter);
                    Class<?> to = delegateMethodParameters.get(numberOfCaptures + typeParameter);
                    AnalyzerCaster.getLegalCast(location, from, to, false, true);
                }
                if (interfaceMethod.returnType() != Void.TYPE) {
                    AnalyzerCaster.getLegalCast(location, delegateMethodReturnType, interfaceMethod.returnType(), false, true);
                }
            }
            MethodType factoryMethodType = MethodType.methodType(targetClass, delegateMethodType.dropParameterTypes(numberOfCaptures, delegateMethodType.parameterCount()));
            delegateMethodType = delegateMethodType.dropParameterTypes(0, numberOfCaptures);
            return new FunctionRef(interfaceMethodName, interfaceMethodType, delegateClassName, isDelegateInterface, isDelegateAugmented, delegateInvokeType, delegateMethodName, delegateMethodType, delegateInjections, factoryMethodType, needsScriptInstance ? WriterConstants.CLASS_TYPE : null);
        }
        catch (IllegalArgumentException iae) {
            if (location != null) {
                throw location.createError(iae);
            }
            throw iae;
        }
    }

    private FunctionRef(String interfaceMethodName, MethodType interfaceMethodType, String delegateClassName, boolean isDelegateInterface, boolean isDelegateAugmented, int delegateInvokeType, String delegateMethodName, MethodType delegateMethodType, Object[] delegateInjections, MethodType factoryMethodType, Type factoryMethodReceiver) {
        this.interfaceMethodName = interfaceMethodName;
        this.interfaceMethodType = interfaceMethodType;
        this.delegateClassName = delegateClassName;
        this.isDelegateInterface = isDelegateInterface;
        this.isDelegateAugmented = isDelegateAugmented;
        this.delegateInvokeType = delegateInvokeType;
        this.delegateMethodName = delegateMethodName;
        this.delegateMethodType = delegateMethodType;
        this.delegateInjections = delegateInjections;
        this.factoryMethodType = factoryMethodType;
        this.factoryMethodReceiver = factoryMethodReceiver;
    }

    public String getFactoryMethodDescriptor() {
        if (this.factoryMethodReceiver == null) {
            return this.factoryMethodType.toMethodDescriptorString();
        }
        Type[] arguments = (Type[])Stream.concat(Stream.of(this.factoryMethodReceiver), this.factoryMethodType.parameterList().stream().map(Type::getType)).toArray(Type[]::new);
        return Type.getMethodDescriptor(Type.getType(this.factoryMethodType.returnType()), arguments);
    }

    public Class<?>[] factoryMethodParameters(Class<?> factoryMethodReceiverClass) {
        Class[] parameters = (Class[])this.factoryMethodType.parameterList().toArray(Class[]::new);
        if (factoryMethodReceiverClass != null) {
            Class[] withReceiver = new Class[parameters.length + 1];
            withReceiver[0] = factoryMethodReceiverClass;
            System.arraycopy(parameters, 0, withReceiver, 1, parameters.length);
            parameters = withReceiver;
        }
        return parameters;
    }
}

