/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.repositories.reservedstate.ReservedRepositoryAction;
import org.elasticsearch.action.admin.indices.template.reservedstate.ReservedComposableIndexTemplateAction;
import org.elasticsearch.action.bulk.FailureStoreMetrics;
import org.elasticsearch.action.bulk.IncrementalBulkService;
import org.elasticsearch.action.datastreams.autosharding.DataStreamAutoShardingService;
import org.elasticsearch.action.ingest.ReservedPipelineAction;
import org.elasticsearch.action.search.OnlinePrewarmingService;
import org.elasticsearch.action.search.OnlinePrewarmingServiceProvider;
import org.elasticsearch.action.search.SearchExecutionStatsCollector;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationDiagnosticsService;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.MasterHistoryService;
import org.elasticsearch.cluster.coordination.StableMasterHealthIndicatorService;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreSettings;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.metadata.SystemIndexMetadataUpgradeService;
import org.elasticsearch.cluster.metadata.TemplateUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.project.ProjectResolverFactory;
import org.elasticsearch.cluster.routing.BatchedRerouteService;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdMonitor;
import org.elasticsearch.cluster.routing.allocation.WriteLoadConstraintMonitor;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.DynamicContextDataProvider;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.ConsistentSettingsService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.core.Types;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.FeatureSpecification;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthPeriodicLogger;
import org.elasticsearch.health.HealthService;
import org.elasticsearch.health.metadata.HealthMetadataService;
import org.elasticsearch.health.node.DiskHealthIndicatorService;
import org.elasticsearch.health.node.HealthInfoCache;
import org.elasticsearch.health.node.LocalHealthMonitor;
import org.elasticsearch.health.node.ShardsCapacityHealthIndicatorService;
import org.elasticsearch.health.node.selection.HealthNodeTaskExecutor;
import org.elasticsearch.health.node.tracker.DiskHealthTracker;
import org.elasticsearch.health.node.tracker.HealthTracker;
import org.elasticsearch.health.node.tracker.RepositoriesHealthTracker;
import org.elasticsearch.health.stats.HealthApiStats;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.SlowLogFieldProvider;
import org.elasticsearch.index.SlowLogFields;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.engine.MergeMetrics;
import org.elasticsearch.index.mapper.DefaultRootObjectMapperNamespaceValidator;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.RootObjectMapperNamespaceValidator;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.search.stats.ShardSearchPhaseAPMMetrics;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.IndicesServiceBuilder;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.SystemIndexMappingUpdateService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerMetrics;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.SnapshotFilesProvider;
import org.elasticsearch.indices.recovery.plan.PeerOnlyRecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.ShardSnapshotsService;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.SamplingService;
import org.elasticsearch.injection.guice.Injector;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.Module;
import org.elasticsearch.injection.guice.ModulesBuilder;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.fs.FsHealthService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.metrics.IndicesMetrics;
import org.elasticsearch.monitor.metrics.NodeMetrics;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeServiceProvider;
import org.elasticsearch.node.PluginComponentBinding;
import org.elasticsearch.node.PluginServiceInstances;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.node.ShutdownPrepareService;
import org.elasticsearch.node.internal.TerminationHandler;
import org.elasticsearch.node.internal.TerminationHandlerProvider;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.CircuitBreakerPlugin;
import org.elasticsearch.plugins.ClusterCoordinationPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.HealthPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsLoader;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.RecoveryPlannerPlugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.ShutdownAwarePlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.plugins.TelemetryPlugin;
import org.elasticsearch.plugins.internal.DocumentParsingProvider;
import org.elasticsearch.plugins.internal.DocumentParsingProviderPlugin;
import org.elasticsearch.plugins.internal.InternalVectorFormatProviderPlugin;
import org.elasticsearch.plugins.internal.LoggingDataProvider;
import org.elasticsearch.plugins.internal.ReloadAwarePlugin;
import org.elasticsearch.plugins.internal.RestExtension;
import org.elasticsearch.plugins.internal.SettingsExtension;
import org.elasticsearch.readiness.ReadinessService;
import org.elasticsearch.repositories.RepositoriesModule;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.reservedstate.ReservedStateHandlerProvider;
import org.elasticsearch.reservedstate.action.ReservedClusterSettingsAction;
import org.elasticsearch.reservedstate.service.FileSettingsService;
import org.elasticsearch.reservedstate.service.FileSettingsServiceProvider;
import org.elasticsearch.rest.action.search.SearchResponseMetrics;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchUtils;
import org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.elasticsearch.shutdown.PluginShutdownService;
import org.elasticsearch.snapshots.IndexMetadataRestoreTransformer;
import org.elasticsearch.snapshots.InternalSnapshotsInfoService;
import org.elasticsearch.snapshots.RepositoryIntegrityHealthIndicatorService;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.DefaultBuiltInExecutorBuilders;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.internal.BuiltInExecutorBuilders;
import org.elasticsearch.transport.ClusterSettingsLinkedProjectConfigService;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

class NodeConstruction {
    private final Logger logger = LogManager.getLogger(Node.class);
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Node.class);
    private final List<Closeable> resourcesToClose;
    private final ModulesBuilder modules = new ModulesBuilder();
    private Injector injector;
    private Environment environment;
    private NodeEnvironment nodeEnvironment;
    private PluginsService pluginsService;
    private NodeClient client;
    private Collection<LifecycleComponent> pluginLifecycleComponents;
    private Node.LocalNodeFactory localNodeFactory;
    private NodeService nodeService;
    private TerminationHandler terminationHandler;
    private NamedWriteableRegistry namedWriteableRegistry;
    private NamedXContentRegistry xContentRegistry;

    static NodeConstruction prepareConstruction(Environment initialEnvironment, PluginsLoader pluginsLoader, NodeServiceProvider serviceProvider, boolean forbidPrivateIndexSettings) {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            SettingsModule settingsModule;
            NodeConstruction constructor = new NodeConstruction(closeables);
            Settings settings = constructor.createEnvironment(initialEnvironment, serviceProvider, pluginsLoader);
            constructor.loadLoggingDataProviders();
            TelemetryProvider telemetryProvider = constructor.createTelemetryProvider(settings);
            ThreadPool threadPool = constructor.createThreadPool(settings, telemetryProvider.getMeterRegistry());
            try (ThreadContext.StoredContext ignored = threadPool.getThreadContext().newStoredContext();){
                settingsModule = constructor.validateSettings(initialEnvironment.settings(), settings, threadPool);
            }
            ProjectResolver projectResolver = constructor.pluginsService.loadSingletonServiceProvider(ProjectResolverFactory.class, () -> ProjectResolverFactory.DEFAULT).create();
            constructor.modules.bindToInstance(ProjectResolver.class, projectResolver);
            SearchModule searchModule = constructor.createSearchModule(settingsModule.getSettings(), threadPool, telemetryProvider);
            constructor.createClientAndRegistries(settingsModule.getSettings(), threadPool, searchModule, projectResolver);
            DocumentParsingProvider documentParsingProvider = constructor.getDocumentParsingProvider();
            ScriptService scriptService = constructor.createScriptService(settingsModule, threadPool, serviceProvider, projectResolver);
            constructor.createUpdateHelper(scriptService);
            constructor.construct(threadPool, settingsModule, searchModule, scriptService, constructor.createAnalysisRegistry(), serviceProvider, forbidPrivateIndexSettings, telemetryProvider, documentParsingProvider, projectResolver);
            return constructor;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to bind service", (Throwable)e, new Object[0]);
        }
        finally {
            IOUtils.closeWhileHandlingException(closeables);
        }
    }

    private NodeConstruction(List<Closeable> resourcesToClose) {
        this.resourcesToClose = resourcesToClose;
    }

    Injector injector() {
        return this.injector;
    }

    Environment environment() {
        return this.environment;
    }

    NodeEnvironment nodeEnvironment() {
        return this.nodeEnvironment;
    }

    PluginsService pluginsService() {
        return this.pluginsService;
    }

    NodeClient client() {
        return this.client;
    }

    Collection<LifecycleComponent> pluginLifecycleComponents() {
        return this.pluginLifecycleComponents;
    }

    Node.LocalNodeFactory localNodeFactory() {
        return this.localNodeFactory;
    }

    NodeService nodeService() {
        return this.nodeService;
    }

    TerminationHandler terminationHandler() {
        return this.terminationHandler;
    }

    NamedWriteableRegistry namedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    NamedXContentRegistry namedXContentRegistry() {
        return this.xContentRegistry;
    }

    private <T> Optional<T> getSinglePlugin(Class<T> pluginClass) {
        return NodeConstruction.getSinglePlugin(this.pluginsService.filterPlugins(pluginClass), pluginClass);
    }

    private static <T> Optional<T> getSinglePlugin(Stream<T> plugins, Class<T> pluginClass) {
        Iterator it = plugins.iterator();
        if (!it.hasNext()) {
            return Optional.empty();
        }
        Object plugin = it.next();
        if (it.hasNext()) {
            ArrayList allPlugins = new ArrayList();
            allPlugins.add(plugin);
            it.forEachRemaining(allPlugins::add);
            throw new IllegalStateException("A single " + pluginClass.getName() + " was expected but got " + String.valueOf(allPlugins));
        }
        return Optional.of(plugin);
    }

    private Settings createEnvironment(Environment initialEnvironment, NodeServiceProvider serviceProvider, PluginsLoader pluginsLoader) {
        Settings envSettings = initialEnvironment.settings();
        DeprecationLogger.initialize(envSettings);
        JvmInfo jvmInfo = JvmInfo.jvmInfo();
        if (Environment.PATH_SHARED_DATA_SETTING.exists(envSettings)) {
            this.deprecationLogger.warn(DeprecationCategory.SETTINGS, "shared-data-path", "setting [path.shared_data] is deprecated and will be removed in a future release", new Object[0]);
        }
        if (initialEnvironment.dataDirs().length > 1) {
            this.deprecationLogger.warn(DeprecationCategory.SETTINGS, "multiple-data-paths", "Configuring multiple [path.data] paths is deprecated. Use RAID or other system level features for utilizing multiple disks. This feature will be removed in a future release.", new Object[0]);
        }
        if (Environment.dataPathUsesList(envSettings)) {
            this.deprecationLogger.warn(DeprecationCategory.SETTINGS, "multiple-data-paths-list", "Configuring [path.data] with a list is deprecated. Instead specify as a string value.", new Object[0]);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)initialEnvironment.configDir(), (Object)Arrays.toString(initialEnvironment.dataDirs()), (Object)initialEnvironment.logsDir(), (Object)initialEnvironment.pluginsDir());
        }
        Node.deleteTemporaryApmConfig(jvmInfo, (e, apmConfig) -> this.logger.error("failed to delete temporary APM config file [{}], reason: [{}]", apmConfig, (Object)e.getMessage()));
        this.pluginsService = serviceProvider.newPluginService(initialEnvironment, pluginsLoader);
        this.modules.bindToInstance(PluginsService.class, this.pluginsService);
        Settings settings = Node.mergePluginSettings(this.pluginsService.pluginMap(), envSettings);
        this.environment = new Environment(settings, initialEnvironment.configDir());
        Environment.assertEquivalent(initialEnvironment, this.environment);
        this.modules.bindToInstance(Environment.class, this.environment);
        return settings;
    }

    private void loadLoggingDataProviders() {
        DynamicContextDataProvider.setDataProviders(this.pluginsService.loadServiceProviders(LoggingDataProvider.class));
    }

    private TelemetryProvider createTelemetryProvider(Settings settings) {
        return this.getSinglePlugin(TelemetryPlugin.class).map(p -> p.getTelemetryProvider(settings)).orElse(TelemetryProvider.NOOP);
    }

    private ThreadPool createThreadPool(Settings settings, MeterRegistry meterRegistry) throws IOException {
        ThreadPool threadPool = new ThreadPool(settings, meterRegistry, this.pluginsService.loadSingletonServiceProvider(BuiltInExecutorBuilders.class, DefaultBuiltInExecutorBuilders::new), (ExecutorBuilder[])this.pluginsService.flatMap(p -> p.getExecutorBuilders(settings)).toArray(ExecutorBuilder[]::new));
        this.resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
        this.modules.bindToInstance(ThreadPool.class, threadPool);
        HeaderWarning.setThreadContext(threadPool.getThreadContext());
        this.resourcesToClose.add(() -> HeaderWarning.removeThreadContext(threadPool.getThreadContext()));
        return threadPool;
    }

    private SettingsModule validateSettings(Settings envSettings, Settings settings, ThreadPool threadPool) throws IOException {
        ArrayList additionalSettings = new ArrayList(this.pluginsService.flatMap(Plugin::getSettings).toList());
        for (ExecutorBuilder builder : threadPool.builders()) {
            additionalSettings.addAll(builder.getRegisteredSettings());
        }
        NodeConstruction.addBwcSearchWorkerSettings(additionalSettings);
        SettingsExtension.load().forEach(e -> additionalSettings.addAll(e.getSettings()));
        SettingsModule settingsModule = new SettingsModule(settings, additionalSettings, this.pluginsService.flatMap(Plugin::getSettingsFilter).toList());
        this.modules.add(settingsModule);
        this.nodeEnvironment = new NodeEnvironment(envSettings, this.environment);
        this.logger.info("node name [{}], node ID [{}], cluster name [{}], roles {}", (Object)Node.NODE_NAME_SETTING.get(envSettings), (Object)this.nodeEnvironment.nodeId(), (Object)ClusterName.CLUSTER_NAME_SETTING.get(envSettings).value(), (Object)DiscoveryNode.getRolesFromSettings(settings).stream().map(DiscoveryNodeRole::roleName).collect(Collectors.toCollection(LinkedHashSet::new)));
        this.resourcesToClose.add(this.nodeEnvironment);
        this.modules.bindToInstance(NodeEnvironment.class, this.nodeEnvironment);
        return settingsModule;
    }

    private static void addBwcSearchWorkerSettings(List<Setting<?>> additionalSettings) {
        additionalSettings.add(Setting.intSetting("thread_pool.search_worker.queue_size", 0, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning));
        additionalSettings.add(Setting.intSetting("thread_pool.search_worker.size", 0, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning));
        additionalSettings.add(Setting.intSetting("thread_pool.search_throttled.queue_size", 0, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning));
        additionalSettings.add(Setting.intSetting("thread_pool.search_throttled.size", 0, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning));
    }

    private SearchModule createSearchModule(Settings settings, ThreadPool threadPool, TelemetryProvider telemetryProvider) {
        IndexSearcher.setMaxClauseCount(SearchUtils.calculateMaxClauseValue(threadPool));
        return new SearchModule(settings, this.pluginsService.filterPlugins(SearchPlugin.class).toList(), telemetryProvider);
    }

    private void createClientAndRegistries(Settings settings, ThreadPool threadPool, SearchModule searchModule, ProjectResolver projectResolver) {
        this.client = new NodeClient(settings, threadPool, projectResolver);
        this.modules.add(b -> {
            b.bind(Client.class).toInstance(this.client);
            b.bind(NodeClient.class).toInstance(this.client);
        });
        this.localNodeFactory = new Node.LocalNodeFactory(settings, this.nodeEnvironment.nodeId());
        this.namedWriteableRegistry = new NamedWriteableRegistry(Stream.of(NetworkModule.getNamedWriteables().stream(), IndicesModule.getNamedWriteables().stream(), searchModule.getNamedWriteables().stream(), this.pluginsService.flatMap(Plugin::getNamedWriteables), ClusterModule.getNamedWriteables().stream()).flatMap(Function.identity()).toList());
        this.xContentRegistry = new NamedXContentRegistry(Stream.of(NetworkModule.getNamedXContents().stream(), IndicesModule.getNamedXContents().stream(), searchModule.getNamedXContents().stream(), this.pluginsService.flatMap(Plugin::getNamedXContent), ClusterModule.getNamedXWriteables().stream(), HealthNodeTaskExecutor.getNamedXContentParsers().stream()).flatMap(Function.identity()).toList());
        this.modules.add(b -> {
            b.bind(NamedWriteableRegistry.class).toInstance(this.namedWriteableRegistry);
            b.bind(NamedXContentRegistry.class).toInstance(this.xContentRegistry);
        });
    }

    private ScriptService createScriptService(SettingsModule settingsModule, ThreadPool threadPool, NodeServiceProvider serviceProvider, ProjectResolver projectResolver) {
        Settings settings = settingsModule.getSettings();
        ScriptModule scriptModule = new ScriptModule(settings, this.pluginsService.filterPlugins(ScriptPlugin.class).toList());
        ScriptService scriptService = serviceProvider.newScriptService(this.pluginsService, settings, scriptModule.engines, scriptModule.contexts, threadPool::absoluteTimeInMillis, projectResolver);
        ScriptModule.registerClusterSettingsListeners(scriptService, settingsModule.getClusterSettings());
        this.modules.add(b -> b.bind(ScriptService.class).toInstance(scriptService));
        return scriptService;
    }

    private DataStreamGlobalRetentionSettings createDataStreamServicesAndGlobalRetentionResolver(ThreadPool threadPool, ClusterService clusterService, IndicesService indicesService, MetadataCreateIndexService metadataCreateIndexService) {
        DataStreamGlobalRetentionSettings dataStreamGlobalRetentionSettings = DataStreamGlobalRetentionSettings.create(clusterService.getClusterSettings());
        this.modules.bindToInstance(DataStreamGlobalRetentionSettings.class, dataStreamGlobalRetentionSettings);
        this.modules.bindToInstance(DataStreamFailureStoreSettings.class, DataStreamFailureStoreSettings.create(clusterService.getClusterSettings()));
        this.modules.bindToInstance(MetadataCreateDataStreamService.class, new MetadataCreateDataStreamService(threadPool, clusterService, metadataCreateIndexService));
        this.modules.bindToInstance(MetadataDataStreamsService.class, new MetadataDataStreamsService(clusterService, indicesService, dataStreamGlobalRetentionSettings));
        return dataStreamGlobalRetentionSettings;
    }

    private UpdateHelper createUpdateHelper(ScriptService scriptService) {
        UpdateHelper updateHelper = new UpdateHelper(scriptService);
        this.modules.add(b -> b.bind(UpdateHelper.class).toInstance(updateHelper));
        return updateHelper;
    }

    private AnalysisRegistry createAnalysisRegistry() throws IOException {
        AnalysisRegistry registry = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class).toList(), this.pluginsService.getStablePluginRegistry()).getAnalysisRegistry();
        this.modules.bindToInstance(AnalysisRegistry.class, registry);
        return registry;
    }

    private void construct(ThreadPool threadPool, SettingsModule settingsModule, SearchModule searchModule, ScriptService scriptService, AnalysisRegistry analysisRegistry, NodeServiceProvider serviceProvider, boolean forbidPrivateIndexSettings, TelemetryProvider telemetryProvider, DocumentParsingProvider documentParsingProvider, ProjectResolver projectResolver) throws IOException {
        Settings settings = settingsModule.getSettings();
        this.modules.bindToInstance(Tracer.class, telemetryProvider.getTracer());
        RootObjectMapperNamespaceValidator namespaceValidator = this.pluginsService.loadSingletonServiceProvider(RootObjectMapperNamespaceValidator.class, () -> new DefaultRootObjectMapperNamespaceValidator());
        this.modules.bindToInstance(RootObjectMapperNamespaceValidator.class, namespaceValidator);
        assert (this.nodeEnvironment.nodeId() != null) : "node ID must be set before constructing the Node";
        TaskManager taskManager = new TaskManager(settings, threadPool, Stream.concat(this.pluginsService.filterPlugins(ActionPlugin.class).flatMap(p -> p.getTaskHeaders().stream()), Task.HEADERS_TO_COPY.stream()).collect(Collectors.toSet()), telemetryProvider.getTracer(), this.nodeEnvironment.nodeId());
        ClusterService clusterService = this.createClusterService(settingsModule, threadPool, taskManager);
        clusterService.addStateApplier(scriptService);
        this.modules.bindToInstance(DocumentParsingProvider.class, documentParsingProvider);
        FeatureService featureService = new FeatureService(this.pluginsService.loadServiceProviders(FeatureSpecification.class));
        SamplingService samplingService = new SamplingService(scriptService, clusterService, projectResolver, threadPool.relativeTimeInMillisSupplier());
        this.modules.bindToInstance(SamplingService.class, samplingService);
        clusterService.addListener(samplingService);
        FailureStoreMetrics failureStoreMetrics = new FailureStoreMetrics(telemetryProvider.getMeterRegistry());
        IngestService ingestService = new IngestService(clusterService, threadPool, this.environment, scriptService, analysisRegistry, this.pluginsService.filterPlugins(IngestPlugin.class).toList(), this.client, IngestService.createGrokThreadWatchdog(this.environment, threadPool), failureStoreMetrics, projectResolver, featureService, samplingService);
        SystemIndices systemIndices = this.createSystemIndices(settings);
        CircuitBreakerService circuitBreakerService = this.createCircuitBreakerService(new CircuitBreakerMetrics(telemetryProvider), settingsModule.getSettings(), settingsModule.getClusterSettings());
        PageCacheRecycler pageCacheRecycler = serviceProvider.newPageCacheRecycler(this.pluginsService, settings);
        BigArrays bigArrays = serviceProvider.newBigArrays(this.pluginsService, pageCacheRecycler, circuitBreakerService);
        RecoverySettings recoverySettings = new RecoverySettings(settings, settingsModule.getClusterSettings());
        SnapshotMetrics snapshotMetrics = new SnapshotMetrics(telemetryProvider.getMeterRegistry());
        RepositoriesModule repositoriesModule = new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class).toList(), this.client, threadPool, clusterService, bigArrays, this.xContentRegistry, recoverySettings, telemetryProvider, snapshotMetrics);
        RepositoriesService repositoriesService = repositoriesModule.getRepositoryService();
        SetOnce<BatchedRerouteService> rerouteServiceReference = new SetOnce<BatchedRerouteService>();
        ClusterInfoService clusterInfoService = serviceProvider.newClusterInfoService(this.pluginsService, settings, clusterService, threadPool, this.client);
        InternalSnapshotsInfoService snapshotsInfoService = new InternalSnapshotsInfoService(settings, clusterService, repositoriesService, rerouteServiceReference::get);
        ClusterModule clusterModule = new ClusterModule(settings, clusterService, this.pluginsService.filterPlugins(ClusterPlugin.class).toList(), clusterInfoService, snapshotsInfoService, threadPool, systemIndices, projectResolver, this.getWriteLoadForecaster(threadPool, settings, clusterService.getClusterSettings()), telemetryProvider);
        this.modules.add(clusterModule);
        BatchedRerouteService rerouteService = new BatchedRerouteService(clusterService, clusterModule.getAllocationService()::reroute);
        rerouteServiceReference.set(rerouteService);
        clusterInfoService.addListener(new DiskThresholdMonitor(settings, clusterService::state, clusterService.getClusterSettings(), this.client, threadPool.relativeTimeInMillisSupplier(), rerouteService, projectResolver)::onNewInfo);
        clusterInfoService.addListener(new WriteLoadConstraintMonitor(clusterService.getClusterSettings(), threadPool.relativeTimeInMillisSupplier(), clusterService::state, rerouteService)::onNewInfo);
        IndicesModule indicesModule = new IndicesModule(this.pluginsService.filterPlugins(MapperPlugin.class).toList(), this.pluginsService.filterPlugins(InternalVectorFormatProviderPlugin.class).toList(), namespaceValidator);
        this.modules.add(indicesModule);
        this.modules.add(new GatewayModule());
        CompatibilityVersions compatibilityVersions = new CompatibilityVersions(TransportVersion.current(), systemIndices.getMappingsVersions());
        this.modules.add(this.loadPersistedClusterStateService(clusterService.getClusterSettings(), threadPool, compatibilityVersions, projectResolver));
        MetaStateService metaStateService = new MetaStateService(this.nodeEnvironment, this.xContentRegistry);
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addListener(new SystemIndexMappingUpdateService(systemIndices, this.client, projectResolver));
        }
        SourceFieldMetrics sourceFieldMetrics = new SourceFieldMetrics(telemetryProvider.getMeterRegistry(), threadPool::relativeTimeInMillis);
        MapperMetrics mapperMetrics = new MapperMetrics(sourceFieldMetrics);
        MergeMetrics mergeMetrics = new MergeMetrics(telemetryProvider.getMeterRegistry());
        List<SearchOperationListener> searchOperationListeners = List.of(new ShardSearchPhaseAPMMetrics(telemetryProvider.getMeterRegistry()));
        final List<SlowLogFieldProvider> slowLogFieldProviders = this.pluginsService.loadServiceProviders(SlowLogFieldProvider.class);
        SlowLogFieldProvider slowLogFieldProvider = new SlowLogFieldProvider(){

            @Override
            public SlowLogFields create() {
                final ArrayList<SlowLogFields> fields = new ArrayList<SlowLogFields>();
                for (SlowLogFieldProvider provider : slowLogFieldProviders) {
                    fields.add(provider.create());
                }
                return new SlowLogFields(){

                    @Override
                    public Map<String, String> indexFields() {
                        return fields.stream().flatMap(f -> f.indexFields().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    }

                    @Override
                    public Map<String, String> searchFields() {
                        return fields.stream().flatMap(f -> f.searchFields().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    }

                    @Override
                    public Map<String, String> queryFields() {
                        return fields.stream().flatMap(f -> f.queryFields().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    }
                };
            }

            @Override
            public SlowLogFields create(IndexSettings indexSettings) {
                final ArrayList<SlowLogFields> fields = new ArrayList<SlowLogFields>();
                for (SlowLogFieldProvider provider : slowLogFieldProviders) {
                    fields.add(provider.create(indexSettings));
                }
                return new SlowLogFields(){

                    @Override
                    public Map<String, String> indexFields() {
                        return fields.stream().flatMap(f -> f.indexFields().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    }

                    @Override
                    public Map<String, String> searchFields() {
                        return fields.stream().flatMap(f -> f.searchFields().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    }

                    @Override
                    public Map<String, String> queryFields() {
                        return fields.stream().flatMap(f -> f.queryFields().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    }
                };
            }
        };
        IndicesService indicesService = new IndicesServiceBuilder().settings(settings).pluginsService(this.pluginsService).nodeEnvironment(this.nodeEnvironment).xContentRegistry(this.xContentRegistry).analysisRegistry(analysisRegistry).indexNameExpressionResolver(clusterModule.getIndexNameExpressionResolver()).mapperRegistry(indicesModule.getMapperRegistry()).namedWriteableRegistry(this.namedWriteableRegistry).threadPool(threadPool).indexScopedSettings(settingsModule.getIndexScopedSettings()).circuitBreakerService(circuitBreakerService).bigArrays(bigArrays).scriptService(scriptService).clusterService(clusterService).projectResolver(projectResolver).client(this.client).metaStateService(metaStateService).valuesSourceRegistry(searchModule.getValuesSourceRegistry()).requestCacheKeyDifferentiator(searchModule.getRequestCacheKeyDifferentiator()).mapperMetrics(mapperMetrics).mergeMetrics(mergeMetrics).searchOperationListeners(searchOperationListeners).slowLogFieldProvider(slowLogFieldProvider).build();
        IndexSettingProvider.Parameters parameters = new IndexSettingProvider.Parameters(clusterService, indicesService::createIndexMapperServiceForValidation);
        IndexSettingProviders indexSettingProviders = new IndexSettingProviders(Sets.union(this.builtinIndexSettingProviders(), this.pluginsService.flatMap(p -> p.getAdditionalIndexSettingProviders(parameters)).collect(Collectors.toSet())));
        ShardLimitValidator shardLimitValidator = new ShardLimitValidator(settings, clusterService);
        MetadataCreateIndexService metadataCreateIndexService = new MetadataCreateIndexService(settings, clusterService, indicesService, clusterModule.getAllocationService(), shardLimitValidator, this.environment, settingsModule.getIndexScopedSettings(), threadPool, this.xContentRegistry, systemIndices, forbidPrivateIndexSettings, indexSettingProviders);
        MetadataUpdateSettingsService metadataUpdateSettingsService = new MetadataUpdateSettingsService(clusterService, clusterModule.getAllocationService(), settingsModule.getIndexScopedSettings(), indicesService, shardLimitValidator, threadPool);
        DataStreamGlobalRetentionSettings dataStreamGlobalRetentionSettings = this.createDataStreamServicesAndGlobalRetentionResolver(threadPool, clusterService, indicesService, metadataCreateIndexService);
        MetadataIndexTemplateService metadataIndexTemplateService = new MetadataIndexTemplateService(clusterService, metadataCreateIndexService, indicesService, settingsModule.getIndexScopedSettings(), this.xContentRegistry, systemIndices, indexSettingProviders, dataStreamGlobalRetentionSettings);
        IndexingPressure indexingLimits = new IndexingPressure(settings);
        LinkedProjectConfigService linkedProjectConfigService = this.pluginsService.loadSingletonServiceProvider(LinkedProjectConfigService.class, () -> new ClusterSettingsLinkedProjectConfigService(settings, clusterService.getClusterSettings(), projectResolver));
        PluginServiceInstances pluginServices = new PluginServiceInstances(this.client, clusterService, rerouteService, threadPool, this.createResourceWatcherService(settings, threadPool), scriptService, this.xContentRegistry, this.environment, this.nodeEnvironment, this.namedWriteableRegistry, clusterModule.getIndexNameExpressionResolver(), repositoriesService, telemetryProvider, clusterModule.getAllocationService(), indicesService, featureService, systemIndices, dataStreamGlobalRetentionSettings, documentParsingProvider, taskManager, projectResolver, slowLogFieldProvider, indexingLimits, linkedProjectConfigService);
        List pluginComponents = this.pluginsService.flatMap(plugin -> {
            Set<Object> componentsFromInjector;
            Collection<?> allItems = plugin.createComponents(pluginServices);
            List<Object> componentObjects = allItems.stream().filter(Predicate.not(x -> x instanceof Class)).toList();
            List<Class> classes = allItems.stream().filter(x -> x instanceof Class).map(x -> (Class)x).toList();
            if (classes.isEmpty()) {
                componentsFromInjector = Set.of();
            } else {
                this.logger.debug("Using injector to instantiate classes for {}: {}", (Object)plugin.getClass().getSimpleName(), classes);
                org.elasticsearch.injection.Injector injector = org.elasticsearch.injection.Injector.create();
                injector.addInstances(componentObjects);
                NodeConstruction.addRecordContents(injector, pluginServices);
                Map<Class<?>, Object> resultMap = injector.inject(classes);
                Set distinctObjects = Collections.newSetFromMap(new IdentityHashMap());
                distinctObjects.addAll(resultMap.values());
                componentsFromInjector = distinctObjects;
            }
            return Stream.of(componentObjects, componentsFromInjector).flatMap(Collection::stream).toList();
        }).toList();
        Stream<TerminationHandler> terminationHandlers = this.pluginsService.loadServiceProviders(TerminationHandlerProvider.class).stream().map(TerminationHandlerProvider::handler);
        this.terminationHandler = NodeConstruction.getSinglePlugin(terminationHandlers, TerminationHandler.class).orElse(null);
        IncrementalBulkService incrementalBulkService = new IncrementalBulkService(this.client, indexingLimits, telemetryProvider.getMeterRegistry());
        ResponseCollectorService responseCollectorService = new ResponseCollectorService(clusterService);
        this.modules.bindToInstance(ResponseCollectorService.class, responseCollectorService);
        List<ReservedStateHandlerProvider> reservedStateHandlerProviders = this.pluginsService.loadServiceProviders(ReservedStateHandlerProvider.class);
        ActionModule actionModule = new ActionModule(settings, clusterModule.getIndexNameExpressionResolver(), this.namedWriteableRegistry, settingsModule.getIndexScopedSettings(), settingsModule.getClusterSettings(), settingsModule.getSettingsFilter(), threadPool, this.pluginsService.filterPlugins(ActionPlugin.class).toList(), this.client, circuitBreakerService, this.createUsageService(), systemIndices, telemetryProvider, clusterService, rerouteService, this.buildReservedClusterStateHandlers(reservedStateHandlerProviders, settingsModule), this.buildReservedProjectStateHandlers(reservedStateHandlerProviders, settingsModule, metadataIndexTemplateService), this.pluginsService.loadSingletonServiceProvider(RestExtension.class, RestExtension::allowAll), incrementalBulkService, projectResolver);
        this.modules.add(actionModule);
        NetworkService networkService = new NetworkService(this.pluginsService.filterPlugins(DiscoveryPlugin.class).map(d -> d.getCustomNameResolver(this.environment.settings())).filter(Objects::nonNull).toList());
        NetworkModule networkModule = new NetworkModule(settings, this.pluginsService.filterPlugins(NetworkPlugin.class).toList(), threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, this.namedWriteableRegistry, this.xContentRegistry, networkService, actionModule.getRestController(), actionModule::copyRequestHeadersToThreadContext, clusterService.getClusterSettings(), telemetryProvider);
        List<UnaryOperator<Map<String, IndexTemplateMetadata>>> indexTemplateMetadataUpgraders = this.pluginsService.map(Plugin::getIndexTemplateMetadataUpgrader).toList();
        List<Map<String, UnaryOperator<Metadata.ProjectCustom>>> customMetadataUpgraders = this.pluginsService.map(Plugin::getProjectCustomMetadataUpgraders).toList();
        this.modules.bindToInstance(MetadataUpgrader.class, new MetadataUpgrader(indexTemplateMetadataUpgraders, customMetadataUpgraders));
        IndexMetadataVerifier indexMetadataVerifier = new IndexMetadataVerifier(settings, clusterService, this.xContentRegistry, indicesModule.getMapperRegistry(), settingsModule.getIndexScopedSettings(), scriptService, mapperMetrics);
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addListener(new SystemIndexMetadataUpgradeService(systemIndices, clusterService));
            clusterService.addListener(new TemplateUpgradeService(this.client, clusterService, threadPool, indexTemplateMetadataUpgraders));
        }
        Transport transport = networkModule.getTransportSupplier().get();
        TransportService transportService = serviceProvider.newTransportService(this.pluginsService, settings, transport, threadPool, networkModule.getTransportInterceptor(), this.localNodeFactory, settingsModule.getClusterSettings(), taskManager, telemetryProvider.getTracer(), this.nodeEnvironment.nodeId(), linkedProjectConfigService, projectResolver);
        SearchResponseMetrics searchResponseMetrics = new SearchResponseMetrics(telemetryProvider.getMeterRegistry());
        SearchTransportService searchTransportService = new SearchTransportService(transportService, this.client, SearchExecutionStatsCollector.makeWrapper(responseCollectorService));
        HttpServerTransport httpServerTransport = serviceProvider.newHttpTransport(this.pluginsService, networkModule);
        SnapshotsService snapshotsService = new SnapshotsService(settings, clusterService, rerouteService, clusterModule.getIndexNameExpressionResolver(), repositoriesService, transportService, systemIndices, projectResolver.supportsMultipleProjects(), snapshotMetrics);
        SnapshotShardsService snapshotShardsService = new SnapshotShardsService(settings, clusterService, repositoriesService, transportService, indicesService);
        actionModule.getReservedClusterStateService().installProjectStateHandler(new ReservedRepositoryAction(repositoriesService));
        actionModule.getReservedClusterStateService().installProjectStateHandler(new ReservedPipelineAction());
        FileSettingsService.FileSettingsHealthIndicatorPublisherImpl fileSettingsHealthIndicatorPublisher = new FileSettingsService.FileSettingsHealthIndicatorPublisherImpl(clusterService, this.client);
        FileSettingsService.FileSettingsHealthTracker fileSettingsHealthTracker = new FileSettingsService.FileSettingsHealthTracker(settings, fileSettingsHealthIndicatorPublisher);
        FileSettingsService fileSettingsService = this.pluginsService.loadSingletonServiceProvider(FileSettingsServiceProvider.class, () -> FileSettingsService::new).construct(clusterService, actionModule.getReservedClusterStateService(), this.environment, fileSettingsHealthTracker);
        RestoreService restoreService = new RestoreService(clusterService, repositoriesService, clusterModule.getAllocationService(), metadataCreateIndexService, indexMetadataVerifier, shardLimitValidator, systemIndices, indicesService, fileSettingsService, threadPool, projectResolver.supportsMultipleProjects(), this.pluginsService.loadSingletonServiceProvider(IndexMetadataRestoreTransformer.class, IndexMetadataRestoreTransformer.NoOpRestoreTransformer::getInstance));
        DiscoveryModule discoveryModule = this.createDiscoveryModule(settings, threadPool, transportService, networkService, clusterService, clusterModule.getAllocationService(), rerouteService, circuitBreakerService, compatibilityVersions, featureService);
        this.nodeService = new NodeService(settings, threadPool, new MonitorService(settings, this.nodeEnvironment, threadPool), discoveryModule.getCoordinator(), transportService, indicesService, this.pluginsService, circuitBreakerService, scriptService, httpServerTransport, ingestService, clusterService, settingsModule.getSettingsFilter(), responseCollectorService, searchTransportService, indexingLimits, searchModule.getValuesSourceRegistry().getUsageService(), repositoriesService, compatibilityVersions);
        TimeValue metricsInterval = settings.getAsTime("telemetry.agent.metrics_interval", TimeValue.timeValueSeconds(10L));
        NodeMetrics nodeMetrics = new NodeMetrics(telemetryProvider.getMeterRegistry(), this.nodeService, metricsInterval);
        IndicesMetrics indicesMetrics = new IndicesMetrics(telemetryProvider.getMeterRegistry(), indicesService, metricsInterval);
        OnlinePrewarmingService onlinePrewarmingService = this.pluginsService.loadSingletonServiceProvider(OnlinePrewarmingServiceProvider.class, () -> OnlinePrewarmingServiceProvider.DEFAULT).create(clusterService.getSettings(), threadPool, clusterService, telemetryProvider);
        SearchService searchService = serviceProvider.newSearchService(this.pluginsService, clusterService, indicesService, threadPool, scriptService, bigArrays, searchModule.getFetchPhase(), circuitBreakerService, systemIndices.getExecutorSelector(), telemetryProvider.getTracer(), onlinePrewarmingService);
        ShutdownPrepareService shutdownPrepareService = new ShutdownPrepareService(settings, httpServerTransport, this.terminationHandler);
        this.modules.add(this.loadPersistentTasksService(settingsModule, clusterService, threadPool, clusterModule.getIndexNameExpressionResolver()));
        this.modules.add(this.loadPluginShutdownService(clusterService), this.loadDiagnosticServices(settings, discoveryModule.getCoordinator(), clusterService, transportService, threadPool, telemetryProvider, repositoriesService));
        RecoveryPlannerService recoveryPlannerService = this.getRecoveryPlannerService(threadPool, clusterService, repositoriesService);
        this.modules.add(b -> {
            serviceProvider.processRecoverySettings(this.pluginsService, settingsModule.getClusterSettings(), recoverySettings);
            SnapshotFilesProvider snapshotFilesProvider = new SnapshotFilesProvider(repositoriesService);
            PeerRecoverySourceService peerRecovery = new PeerRecoverySourceService(transportService, indicesService, clusterService, recoverySettings, recoveryPlannerService);
            this.resourcesToClose.add(peerRecovery);
            b.bind(PeerRecoverySourceService.class).toInstance(peerRecovery);
            b.bind(PeerRecoveryTargetService.class).toInstance(new PeerRecoveryTargetService(this.client, threadPool, transportService, recoverySettings, clusterService, snapshotFilesProvider));
        });
        this.modules.add(this.loadPluginComponents(pluginComponents));
        DataStreamAutoShardingService dataStreamAutoShardingService = new DataStreamAutoShardingService(settings, clusterService, threadPool::absoluteTimeInMillis);
        dataStreamAutoShardingService.init();
        this.modules.add(b -> {
            b.bind(NodeService.class).toInstance(this.nodeService);
            b.bind(BigArrays.class).toInstance(bigArrays);
            b.bind(PageCacheRecycler.class).toInstance(pageCacheRecycler);
            b.bind(IngestService.class).toInstance(ingestService);
            b.bind(IndexingPressure.class).toInstance(indexingLimits);
            b.bind(IncrementalBulkService.class).toInstance(incrementalBulkService);
            b.bind(AggregationUsageService.class).toInstance(searchModule.getValuesSourceRegistry().getUsageService());
            b.bind(MetaStateService.class).toInstance(metaStateService);
            b.bind(IndicesService.class).toInstance(indicesService);
            b.bind(MetadataCreateIndexService.class).toInstance(metadataCreateIndexService);
            b.bind(MetadataUpdateSettingsService.class).toInstance(metadataUpdateSettingsService);
            b.bind(MetadataIndexTemplateService.class).toInstance(metadataIndexTemplateService);
            b.bind(SearchService.class).toInstance(searchService);
            b.bind(SearchResponseMetrics.class).toInstance(searchResponseMetrics);
            b.bind(SearchTransportService.class).toInstance(searchTransportService);
            b.bind(SearchPhaseController.class).toInstance(new SearchPhaseController(searchService::aggReduceContextBuilder));
            b.bind(Transport.class).toInstance(transport);
            b.bind(TransportService.class).toInstance(transportService);
            b.bind(NodeMetrics.class).toInstance(nodeMetrics);
            b.bind(IndicesMetrics.class).toInstance(indicesMetrics);
            b.bind(NetworkService.class).toInstance(networkService);
            b.bind(IndexMetadataVerifier.class).toInstance(indexMetadataVerifier);
            b.bind(ClusterInfoService.class).toInstance(clusterInfoService);
            b.bind(SnapshotsInfoService.class).toInstance(snapshotsInfoService);
            b.bind(FeatureService.class).toInstance(featureService);
            b.bind(HttpServerTransport.class).toInstance(httpServerTransport);
            b.bind(RepositoriesService.class).toInstance(repositoriesService);
            b.bind(SnapshotsService.class).toInstance(snapshotsService);
            b.bind(SnapshotShardsService.class).toInstance(snapshotShardsService);
            b.bind(RestoreService.class).toInstance(restoreService);
            b.bind(RerouteService.class).toInstance(rerouteService);
            b.bind(ShardLimitValidator.class).toInstance(shardLimitValidator);
            b.bind(IndexSettingProviders.class).toInstance(indexSettingProviders);
            b.bind(FileSettingsService.class).toInstance(fileSettingsService);
            b.bind(CompatibilityVersions.class).toInstance(compatibilityVersions);
            b.bind(DataStreamAutoShardingService.class).toInstance(dataStreamAutoShardingService);
            b.bind(FailureStoreMetrics.class).toInstance(failureStoreMetrics);
            b.bind(ShutdownPrepareService.class).toInstance(shutdownPrepareService);
            b.bind(OnlinePrewarmingService.class).toInstance(onlinePrewarmingService);
            b.bind(MergeMetrics.class).toInstance(mergeMetrics);
        });
        if (ReadinessService.enabled(this.environment)) {
            this.modules.bindToInstance(ReadinessService.class, serviceProvider.newReadinessService(this.pluginsService, clusterService, this.environment));
        }
        this.injector = this.modules.createInjector();
        this.postInjection(clusterModule, actionModule, clusterService, transportService, featureService);
    }

    @SuppressForbidden(reason="Can't call invokeExact because we don't know the exact Record subtype statically")
    private static <T> void addRecordContents(org.elasticsearch.injection.Injector injector, Record r) {
        for (RecordComponent c : r.getClass().getRecordComponents()) {
            try {
                Class<?> type = c.getType();
                injector.addInstance(type, type.cast(MethodHandles.lookup().unreflect(c.getAccessor()).invoke(r)));
            }
            catch (Throwable e) {
                throw new IllegalStateException("Unable to read record component " + String.valueOf(c), e);
            }
        }
    }

    private ClusterService createClusterService(SettingsModule settingsModule, ThreadPool threadPool, TaskManager taskManager) {
        ClusterService clusterService = new ClusterService(settingsModule.getSettings(), settingsModule.getClusterSettings(), settingsModule.getProjectScopedSettings(), threadPool, taskManager);
        this.resourcesToClose.add(clusterService);
        Set<Setting<?>> consistentSettings = settingsModule.getConsistentSettings();
        if (!consistentSettings.isEmpty()) {
            clusterService.addLocalNodeMasterListener(new ConsistentSettingsService(settingsModule.getSettings(), clusterService, consistentSettings).newHashPublisher());
        }
        return clusterService;
    }

    private UsageService createUsageService() {
        UsageService usageService = new UsageService();
        this.modules.bindToInstance(UsageService.class, usageService);
        return usageService;
    }

    private SystemIndices createSystemIndices(Settings settings) {
        List<SystemIndices.Feature> features = this.pluginsService.filterPlugins(SystemIndexPlugin.class).map(plugin -> {
            SystemIndices.validateFeatureName(plugin.getFeatureName(), plugin.getClass().getCanonicalName());
            return SystemIndices.Feature.fromSystemIndexPlugin(plugin, settings);
        }).toList();
        SystemIndices systemIndices = new SystemIndices(features);
        this.modules.add(b -> {
            b.bind(SystemIndices.class).toInstance(systemIndices);
            b.bind(ExecutorSelector.class).toInstance(systemIndices.getExecutorSelector());
        });
        return systemIndices;
    }

    private ResourceWatcherService createResourceWatcherService(Settings settings, ThreadPool threadPool) {
        ResourceWatcherService resourceWatcherService = new ResourceWatcherService(settings, threadPool);
        this.resourcesToClose.add(resourceWatcherService);
        this.modules.bindToInstance(ResourceWatcherService.class, resourceWatcherService);
        return resourceWatcherService;
    }

    private Module loadPluginShutdownService(ClusterService clusterService) {
        PluginShutdownService pluginShutdownService = new PluginShutdownService(this.pluginsService.filterPlugins(ShutdownAwarePlugin.class).toList());
        clusterService.addListener(pluginShutdownService);
        return b -> b.bind(PluginShutdownService.class).toInstance(pluginShutdownService);
    }

    private Module loadDiagnosticServices(Settings settings, Coordinator coordinator, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, TelemetryProvider telemetryProvider, RepositoriesService repositoriesService) {
        MasterHistoryService masterHistoryService = new MasterHistoryService(transportService, threadPool, clusterService);
        CoordinationDiagnosticsService coordinationDiagnosticsService = new CoordinationDiagnosticsService(clusterService, transportService, coordinator, masterHistoryService);
        Stream<HealthIndicatorService> serverHealthIndicatorServices = Stream.of(new StableMasterHealthIndicatorService(coordinationDiagnosticsService, clusterService), new RepositoryIntegrityHealthIndicatorService(clusterService), new DiskHealthIndicatorService(clusterService), new ShardsCapacityHealthIndicatorService(clusterService), new FileSettingsService.FileSettingsHealthIndicatorService());
        Stream pluginHealthIndicatorServices = this.pluginsService.filterPlugins(HealthPlugin.class).flatMap(plugin -> plugin.getHealthIndicatorServices().stream());
        HealthService healthService = new HealthService(Stream.concat(serverHealthIndicatorServices, pluginHealthIndicatorServices).toList(), threadPool);
        HealthPeriodicLogger healthPeriodicLogger = HealthPeriodicLogger.create(settings, clusterService, this.client, healthService, telemetryProvider);
        HealthMetadataService healthMetadataService = HealthMetadataService.create(clusterService, settings);
        List<HealthTracker<?>> healthTrackers = List.of(new DiskHealthTracker(this.nodeService, clusterService), new RepositoriesHealthTracker(repositoriesService));
        LocalHealthMonitor localHealthMonitor = LocalHealthMonitor.create(settings, clusterService, threadPool, this.client, healthTrackers);
        HealthInfoCache nodeHealthOverview = HealthInfoCache.create(clusterService);
        return b -> {
            b.bind(HealthService.class).toInstance(healthService);
            b.bind(MasterHistoryService.class).toInstance(masterHistoryService);
            b.bind(CoordinationDiagnosticsService.class).toInstance(coordinationDiagnosticsService);
            b.bind(HealthMetadataService.class).toInstance(healthMetadataService);
            b.bind(LocalHealthMonitor.class).toInstance(localHealthMonitor);
            b.bind(HealthInfoCache.class).toInstance(nodeHealthOverview);
            b.bind(HealthApiStats.class).toInstance(new HealthApiStats());
            b.bind(HealthPeriodicLogger.class).toInstance(healthPeriodicLogger);
        };
    }

    private Module loadPluginComponents(Collection<?> pluginComponents) {
        List<LifecycleComponent> pluginLifecycleComponents = pluginComponents.stream().map(p -> {
            if (p instanceof PluginComponentBinding) {
                PluginComponentBinding pcb = (PluginComponentBinding)p;
                return pcb.impl();
            }
            return p;
        }).filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).toList();
        this.resourcesToClose.addAll(pluginLifecycleComponents);
        this.pluginLifecycleComponents = pluginLifecycleComponents;
        List<ReloadablePlugin> reloadablePlugins = this.pluginsService.filterPlugins(ReloadablePlugin.class).toList();
        this.pluginsService.filterPlugins(ReloadAwarePlugin.class).forEach(p -> p.setReloadCallback(NodeConstruction.wrapPlugins(reloadablePlugins)));
        return b -> pluginComponents.forEach(p -> {
            if (p instanceof PluginComponentBinding) {
                PluginComponentBinding pcb = (PluginComponentBinding)p;
                Class clazz = pcb.inter();
                b.bind(clazz).toInstance(pcb.impl());
            } else {
                Class<?> clazz = p.getClass();
                b.bind(clazz).toInstance(p);
            }
        });
    }

    private void postInjection(ClusterModule clusterModule, ActionModule actionModule, ClusterService clusterService, TransportService transportService, FeatureService featureService) {
        clusterModule.setExistingShardsAllocators(this.injector.getInstance(GatewayAllocator.class));
        Map actions = (Map)Types.forciblyCast(this.injector.getInstance(new Key<Map<ActionType, TransportAction>>(this){}));
        this.client.initialize(actions, transportService.getTaskManager(), () -> clusterService.localNode().getId(), transportService.getLocalNodeConnection(), transportService.getRemoteClusterService());
        this.logger.debug("initializing HTTP handlers ...");
        actionModule.initRestHandlers(() -> clusterService.state().nodesIfRecovered(), f -> {
            ClusterState state = clusterService.state();
            return state.clusterRecovered() && featureService.clusterHasFeature(state, (NodeFeature)f);
        });
        this.logger.info("initialized");
    }

    private DocumentParsingProvider getDocumentParsingProvider() {
        return this.getSinglePlugin(DocumentParsingProviderPlugin.class).map(DocumentParsingProviderPlugin::getDocumentParsingProvider).orElse(DocumentParsingProvider.EMPTY_INSTANCE);
    }

    private CircuitBreakerService createCircuitBreakerService(CircuitBreakerMetrics metrics, Settings settings, ClusterSettings clusterSettings) {
        String type;
        List<Tuple> pluginBreakers = this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).map(p -> Tuple.tuple(p, p.getCircuitBreaker(settings))).toList();
        CircuitBreakerService circuitBreakerService = switch (type = Node.BREAKER_TYPE_KEY.get(settings)) {
            case "hierarchy" -> new HierarchyCircuitBreakerService(metrics, settings, pluginBreakers.stream().map(Tuple::v2).toList(), clusterSettings);
            case "none" -> new NoneCircuitBreakerService();
            default -> throw new IllegalArgumentException("Unknown circuit breaker type [" + type + "]");
        };
        this.modules.bindToInstance(CircuitBreakerService.class, circuitBreakerService);
        pluginBreakers.forEach(t -> {
            CircuitBreaker circuitBreaker = circuitBreakerService.getBreaker(((BreakerSettings)t.v2()).getName());
            ((CircuitBreakerPlugin)t.v1()).setCircuitBreaker(circuitBreaker);
        });
        return circuitBreakerService;
    }

    private static ReloadablePlugin wrapPlugins(List<ReloadablePlugin> reloadablePlugins) {
        return settings -> {
            for (ReloadablePlugin plugin : reloadablePlugins) {
                try {
                    plugin.reload(settings);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    private RecoveryPlannerService getRecoveryPlannerService(ThreadPool threadPool, ClusterService clusterService, RepositoriesService repositoriesService) {
        Stream recoveryPlannerServices = this.pluginsService.filterPlugins(RecoveryPlannerPlugin.class).map(plugin -> plugin.createRecoveryPlannerService(new ShardSnapshotsService(this.client, repositoriesService, threadPool, clusterService))).flatMap(Optional::stream);
        return NodeConstruction.getSinglePlugin(recoveryPlannerServices, RecoveryPlannerService.class).orElseGet(PeerOnlyRecoveryPlannerService::new);
    }

    private WriteLoadForecaster getWriteLoadForecaster(ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        Stream writeLoadForecasters = this.pluginsService.filterPlugins(ClusterPlugin.class).flatMap(clusterPlugin -> clusterPlugin.createWriteLoadForecasters(threadPool, settings, clusterSettings).stream());
        WriteLoadForecaster forecaster = NodeConstruction.getSinglePlugin(writeLoadForecasters, WriteLoadForecaster.class).orElse(WriteLoadForecaster.DEFAULT);
        this.modules.bindToInstance(WriteLoadForecaster.class, forecaster);
        return forecaster;
    }

    private Module loadPersistedClusterStateService(ClusterSettings clusterSettings, ThreadPool threadPool, CompatibilityVersions compatibilityVersions, ProjectResolver projectResolver) {
        Stream persistedClusterStateServiceFactories = this.pluginsService.filterPlugins(ClusterCoordinationPlugin.class).map(ClusterCoordinationPlugin::getPersistedClusterStateServiceFactory).flatMap(Optional::stream);
        PersistedClusterStateService service = NodeConstruction.getSinglePlugin(persistedClusterStateServiceFactories, ClusterCoordinationPlugin.PersistedClusterStateServiceFactory.class).map(f -> f.newPersistedClusterStateService(this.nodeEnvironment, this.xContentRegistry, clusterSettings, threadPool, compatibilityVersions)).orElseGet(() -> new PersistedClusterStateService(this.nodeEnvironment, this.xContentRegistry, clusterSettings, threadPool.relativeTimeInMillisSupplier(), projectResolver::supportsMultipleProjects));
        return b -> b.bind(PersistedClusterStateService.class).toInstance(service);
    }

    private List<ReservedClusterStateHandler<?>> buildReservedClusterStateHandlers(List<? extends ReservedStateHandlerProvider> handlers, SettingsModule settingsModule) {
        ArrayList reservedStateHandlers = new ArrayList();
        reservedStateHandlers.add(new ReservedClusterSettingsAction(settingsModule.getClusterSettings()));
        handlers.forEach(h -> reservedStateHandlers.addAll(h.clusterHandlers()));
        return reservedStateHandlers;
    }

    private List<ReservedProjectStateHandler<?>> buildReservedProjectStateHandlers(List<? extends ReservedStateHandlerProvider> handlers, SettingsModule settingsModule, MetadataIndexTemplateService templateService) {
        ArrayList reservedStateHandlers = new ArrayList();
        reservedStateHandlers.add(new ReservedComposableIndexTemplateAction(templateService, settingsModule.getIndexScopedSettings()));
        handlers.forEach(h -> reservedStateHandlers.addAll(h.projectHandlers()));
        return reservedStateHandlers;
    }

    private DiscoveryModule createDiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NetworkService networkService, ClusterService clusterService, AllocationService allocationService, RerouteService rerouteService, CircuitBreakerService circuitBreakerService, CompatibilityVersions compatibilityVersions, FeatureService featureService) {
        GatewayMetaState gatewayMetaState = new GatewayMetaState();
        FsHealthService fsHealthService = new FsHealthService(settings, clusterService.getClusterSettings(), threadPool, this.nodeEnvironment);
        DiscoveryModule module = new DiscoveryModule(settings, transportService, this.client, this.namedWriteableRegistry, networkService, clusterService.getMasterService(), clusterService.getClusterApplierService(), clusterService.getClusterSettings(), this.pluginsService.filterPlugins(DiscoveryPlugin.class).toList(), this.pluginsService.filterPlugins(ClusterCoordinationPlugin.class).toList(), allocationService, this.environment.configDir(), gatewayMetaState, rerouteService, fsHealthService, circuitBreakerService, compatibilityVersions, featureService);
        this.modules.add(module, b -> {
            b.bind(GatewayMetaState.class).toInstance(gatewayMetaState);
            b.bind(FsHealthService.class).toInstance(fsHealthService);
        });
        return module;
    }

    private Module loadPersistentTasksService(SettingsModule settingsModule, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        PersistentTasksService persistentTasksService = new PersistentTasksService(clusterService, threadPool, this.client);
        HealthNodeTaskExecutor healthNodeTaskExecutor = HealthNodeTaskExecutor.create(clusterService, persistentTasksService, settingsModule.getSettings(), clusterService.getClusterSettings());
        Stream<HealthNodeTaskExecutor> builtinTaskExecutors = Stream.of(healthNodeTaskExecutor);
        Stream pluginTaskExecutors = this.pluginsService.filterPlugins(PersistentTaskPlugin.class).map(p -> p.getPersistentTasksExecutor(clusterService, threadPool, this.client, settingsModule, indexNameExpressionResolver)).flatMap(Collection::stream);
        PersistentTasksExecutorRegistry registry = new PersistentTasksExecutorRegistry(Stream.concat(pluginTaskExecutors, builtinTaskExecutors).toList());
        PersistentTasksClusterService persistentTasksClusterService = new PersistentTasksClusterService(settingsModule.getSettings(), registry, clusterService, threadPool);
        this.resourcesToClose.add(persistentTasksClusterService);
        return b -> {
            b.bind(PersistentTasksService.class).toInstance(persistentTasksService);
            b.bind(HealthNodeTaskExecutor.class).toInstance(healthNodeTaskExecutor);
            b.bind(PersistentTasksExecutorRegistry.class).toInstance(registry);
            b.bind(PersistentTasksClusterService.class).toInstance(persistentTasksClusterService);
        };
    }

    private Set<IndexSettingProvider> builtinIndexSettingProviders() {
        return Set.of(new IndexMode.IndexModeSettingsProvider());
    }
}

