/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.util;

import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public final class CombinedBits
implements Bits {
    private final Bits first;
    private final Bits second;
    private final int length;

    public CombinedBits(Bits first, Bits second) {
        if (first.length() != second.length()) {
            throw new IllegalArgumentException("Provided bits have different lengths: " + first.length() + " != " + second.length());
        }
        this.first = first;
        this.second = second;
        this.length = first.length();
    }

    @Override
    public boolean get(int index) {
        return this.first.get(index) && this.second.get(index);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void applyMask(FixedBitSet bitSet, int offset) {
        this.first.applyMask(bitSet, offset);
        this.second.applyMask(bitSet, offset);
    }
}

