/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logstashbridge.script;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.ingest.common.ProcessorsWhitelistExtension;
import org.elasticsearch.logstashbridge.StableBridgeAPI;
import org.elasticsearch.logstashbridge.common.SettingsBridge;
import org.elasticsearch.painless.PainlessPlugin;
import org.elasticsearch.painless.spi.PainlessExtension;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.script.IngestConditionalScript;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.mustache.MustacheScriptEngine;
import org.elasticsearch.xpack.constantkeyword.ConstantKeywordPainlessExtension;
import org.elasticsearch.xpack.spatial.SpatialPainlessExtension;
import org.elasticsearch.xpack.wildcard.WildcardPainlessExtension;

public interface ScriptServiceBridge
extends StableBridgeAPI<ScriptService>,
Closeable {
    public static ScriptServiceBridge fromInternal(ScriptService delegate) {
        return new ProxyInternal(delegate);
    }

    public static ScriptServiceBridge create(SettingsBridge bridgedSettings, LongSupplier timeProvider) throws IOException {
        ScriptService scriptService = ProxyInternal.getScriptService((Settings)bridgedSettings.toInternal(), timeProvider);
        return ScriptServiceBridge.fromInternal(scriptService);
    }

    public static final class ProxyInternal
    extends StableBridgeAPI.ProxyInternal<ScriptService>
    implements ScriptServiceBridge {
        ProxyInternal(ScriptService delegate) {
            super(delegate);
        }

        private static ScriptService getScriptService(Settings settings, LongSupplier timeProvider) throws IOException {
            List<Whitelist> painlessBaseWhitelist = ProxyInternal.getPainlessBaseWhiteList();
            Map<ScriptContext<IngestConditionalScript.Factory>, List<Whitelist>> scriptContexts = Map.of(IngestScript.CONTEXT, painlessBaseWhitelist, IngestConditionalScript.CONTEXT, painlessBaseWhitelist);
            Map<String, ScriptEngine> scriptEngines = Map.of("painless", ProxyInternal.getPainlessScriptEngine(settings), "mustache", new MustacheScriptEngine(settings));
            return new ScriptService(settings, scriptEngines, ScriptModule.CORE_CONTEXTS, timeProvider, LockdownOnlyDefaultProjectIdResolver.INSTANCE);
        }

        private static List<Whitelist> getPainlessBaseWhiteList() {
            return PainlessPlugin.baseWhiteList();
        }

        private static ScriptEngine getPainlessScriptEngine(Settings settings) throws IOException {
            try (PainlessPlugin painlessPlugin = new PainlessPlugin();){
                painlessPlugin.loadExtensions(new ExtensiblePlugin.ExtensionLoader(){

                    @Override
                    public <T> List<T> loadExtensions(Class<T> extensionPointType) {
                        if (extensionPointType.isAssignableFrom(PainlessExtension.class)) {
                            ArrayList<PainlessExtension> extensions = new ArrayList<PainlessExtension>();
                            extensions.add(new ConstantKeywordPainlessExtension());
                            extensions.add(new ProcessorsWhitelistExtension());
                            extensions.add(new SpatialPainlessExtension());
                            extensions.add(new WildcardPainlessExtension());
                            return extensions;
                        }
                        return List.of();
                    }
                });
                ScriptEngine scriptEngine = painlessPlugin.getScriptEngine(settings, Set.of(IngestScript.CONTEXT, IngestConditionalScript.CONTEXT));
                return scriptEngine;
            }
        }

        @Override
        public void close() throws IOException {
            ((ScriptService)this.internalDelegate).close();
        }

        static class LockdownOnlyDefaultProjectIdResolver
        implements ProjectResolver {
            public static final LockdownOnlyDefaultProjectIdResolver INSTANCE = new LockdownOnlyDefaultProjectIdResolver();

            LockdownOnlyDefaultProjectIdResolver() {
            }

            @Override
            public ProjectId getProjectId() {
                return ProjectId.DEFAULT;
            }

            @Override
            public <E extends Exception> void executeOnProject(ProjectId projectId, CheckedRunnable<E> body) throws E {
                if (!projectId.equals(ProjectId.DEFAULT)) {
                    throw new IllegalArgumentException("Cannot execute on a project other than [" + String.valueOf(ProjectId.DEFAULT) + "]");
                }
                body.run();
            }
        }
    }
}

