/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logstashbridge.ingest;

import java.util.function.BiConsumer;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.logstashbridge.StableBridgeAPI;
import org.elasticsearch.logstashbridge.ingest.AbstractExternalProcessorBridge;
import org.elasticsearch.logstashbridge.ingest.IngestDocumentBridge;

public interface ProcessorBridge
extends StableBridgeAPI<Processor> {
    public String getType();

    public String getTag();

    public String getDescription();

    public boolean isAsync();

    default public void execute(IngestDocumentBridge ingestDocumentBridge, BiConsumer<IngestDocumentBridge, Exception> handler) {
        ((Processor)this.toInternal()).execute(StableBridgeAPI.toInternalNullable(ingestDocumentBridge), (IngestDocument id, Exception exception) -> handler.accept(IngestDocumentBridge.fromInternalNullable(id), (Exception)exception));
    }

    default public IngestDocumentBridge execute(IngestDocumentBridge ingestDocumentBridge) throws Exception {
        IngestDocument internalSourceIngestDocument = (IngestDocument)ingestDocumentBridge.toInternal();
        IngestDocument internalResultIngestDocument = ((Processor)this.toInternal()).execute(internalSourceIngestDocument);
        if (internalResultIngestDocument == internalSourceIngestDocument) {
            return ingestDocumentBridge;
        }
        return IngestDocumentBridge.fromInternalNullable(internalResultIngestDocument);
    }

    public static ProcessorBridge fromInternal(Processor internalProcessor) {
        if (internalProcessor instanceof AbstractExternalProcessorBridge.ProxyExternal) {
            AbstractExternalProcessorBridge.ProxyExternal externalProxy = (AbstractExternalProcessorBridge.ProxyExternal)internalProcessor;
            return externalProxy.getProcessorBridge();
        }
        return new ProxyInternal(internalProcessor);
    }

    public static final class ProxyInternal
    extends StableBridgeAPI.ProxyInternal<Processor>
    implements ProcessorBridge {
        public ProxyInternal(Processor delegate) {
            super(delegate);
        }

        @Override
        public String getType() {
            return ((Processor)this.toInternal()).getType();
        }

        @Override
        public String getTag() {
            return ((Processor)this.toInternal()).getTag();
        }

        @Override
        public String getDescription() {
            return ((Processor)this.toInternal()).getDescription();
        }

        @Override
        public boolean isAsync() {
            return ((Processor)this.toInternal()).isAsync();
        }
    }
}

