/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ingest.geoip.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.Network;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.AbstractCountryResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.City;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Continent;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Country;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Location;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.MaxMind;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Postal;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.RepresentedCountry;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Subdivision;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.Traits;

public abstract class AbstractCityResponse
extends AbstractCountryResponse {
    private final City city;
    private final Location location;
    private final Postal postal;
    private final List<Subdivision> subdivisions;

    AbstractCityResponse(City city, Continent continent, Country country, Location location, MaxMind maxmind, Postal postal, Country registeredCountry, RepresentedCountry representedCountry, List<Subdivision> subdivisions, Traits traits) {
        super(continent, country, maxmind, registeredCountry, representedCountry, traits);
        this.city = city != null ? city : new City();
        this.location = location != null ? location : new Location();
        this.postal = postal != null ? postal : new Postal();
        this.subdivisions = subdivisions != null ? subdivisions : new ArrayList();
    }

    AbstractCityResponse(AbstractCityResponse response, String ipAddress, Network network, List<String> locales) {
        super(response, ipAddress, network, locales);
        this.city = new City(response.getCity(), locales);
        this.location = response.getLocation();
        this.postal = response.getPostal();
        this.subdivisions = AbstractCityResponse.mapSubdivisions(response.getSubdivisions(), locales);
    }

    private static ArrayList<Subdivision> mapSubdivisions(List<Subdivision> subdivisions, List<String> locales) {
        ArrayList<Subdivision> subdivisions2 = new ArrayList<Subdivision>(subdivisions.size());
        for (Subdivision subdivision : subdivisions) {
            subdivisions2.add(new Subdivision(subdivision, locales));
        }
        return subdivisions2;
    }

    public City getCity() {
        return this.city;
    }

    public Location getLocation() {
        return this.location;
    }

    public Postal getPostal() {
        return this.postal;
    }

    public List<Subdivision> getSubdivisions() {
        return new ArrayList<Subdivision>(this.subdivisions);
    }

    @JsonIgnore
    public Subdivision getMostSpecificSubdivision() {
        if (this.subdivisions.isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions.get(this.subdivisions.size() - 1);
    }

    @JsonIgnore
    public Subdivision getLeastSpecificSubdivision() {
        if (this.subdivisions.isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions.get(0);
    }
}

