/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class RecoverFailureDocumentProcessor
extends AbstractProcessor {
    public static final String PRE_RECOVERY_FIELD = "pre_recovery";
    public static final String DOCUMENT_FIELD = "document";
    public static final String SOURCE_FIELD = "source";
    public static final String SOURCE_FIELD_PATH = "document.source";
    public static final String ID_FIELD = "id";
    public static final String INDEX_FIELD = "index";
    public static final String ROUTING_FIELD = "routing";
    public static final String ERROR_FIELD = "error";
    public static final String MISSING_DOCUMENT_ERROR_MSG = "failure store document has unexpected structure, missing required [document] field";
    public static final String MISSING_SOURCE_ERROR_MSG = "failure store document has unexpected structure, missing required [document.source] field";
    public static final String MISSING_ERROR_ERROR_MSG = "failure store document has unexpected structure, missing required [error] field";
    public static final String TYPE = "recover_failure_document";

    RecoverFailureDocumentProcessor(String tag, String description) {
        super(tag, description);
    }

    @Override
    public IngestDocument execute(IngestDocument document) throws Exception {
        String originalId;
        String originalRouting;
        if (!document.hasField(DOCUMENT_FIELD)) {
            throw new IllegalArgumentException(MISSING_DOCUMENT_ERROR_MSG);
        }
        if (!document.hasField(SOURCE_FIELD_PATH)) {
            throw new IllegalArgumentException(MISSING_SOURCE_ERROR_MSG);
        }
        if (!document.hasField(ERROR_FIELD)) {
            throw new IllegalArgumentException(MISSING_ERROR_ERROR_MSG);
        }
        RecoverFailureDocumentProcessor.storePreRecoveryData(document);
        Map failedDocument = document.getFieldValue(DOCUMENT_FIELD, Map.class);
        String originalIndex = (String)failedDocument.get(INDEX_FIELD);
        if (originalIndex != null) {
            document.setFieldValue(IngestDocument.Metadata.INDEX.getFieldName(), originalIndex);
        }
        if ((originalRouting = (String)failedDocument.get(ROUTING_FIELD)) != null) {
            document.setFieldValue(IngestDocument.Metadata.ROUTING.getFieldName(), originalRouting);
        }
        if ((originalId = (String)failedDocument.get(ID_FIELD)) != null) {
            document.setFieldValue(IngestDocument.Metadata.ID.getFieldName(), originalId);
        }
        Map originalSource = (Map)failedDocument.get(SOURCE_FIELD);
        Map<String, Object> source = document.getSource();
        source.clear();
        source.putAll(originalSource);
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private static void storePreRecoveryData(IngestDocument document) {
        Map<String, Object> sourceAndMetadataMap = document.getSourceAndMetadata();
        HashMap preRecoveryData = new HashMap();
        sourceAndMetadataMap.forEach((key, value) -> {
            if (DOCUMENT_FIELD.equals(key) && value instanceof Map) {
                Map docMap = (Map)value;
                HashMap docCopy = new HashMap(docMap);
                docCopy.remove(SOURCE_FIELD);
                preRecoveryData.put(key, docCopy);
            } else {
                preRecoveryData.put(key, value);
            }
        });
        document.getIngestMetadata().put(PRE_RECOVERY_FIELD, preRecoveryData);
    }

    public static final class Factory
    implements Processor.Factory {
        @Override
        public RecoverFailureDocumentProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            return new RecoverFailureDocumentProcessor(processorTag, description);
        }
    }
}

