/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class JoinProcessor
extends AbstractProcessor {
    public static final String TYPE = "join";
    private final String field;
    private final String separator;
    private final String targetField;

    JoinProcessor(String tag, String description, String field, String separator, String targetField) {
        super(tag, description);
        this.field = field;
        this.separator = separator;
        this.targetField = targetField;
    }

    String getField() {
        return this.field;
    }

    String getSeparator() {
        return this.separator;
    }

    String getTargetField() {
        return this.targetField;
    }

    @Override
    public IngestDocument execute(IngestDocument document) {
        List list = document.getFieldValue(this.field, List.class);
        if (list == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot join.");
        }
        String joined = list.stream().map(Object::toString).collect(Collectors.joining(this.separator));
        document.setFieldValue(this.targetField, joined);
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        @Override
        public JoinProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String field = ConfigurationUtils.readStringProperty(JoinProcessor.TYPE, processorTag, config, "field");
            String separator = ConfigurationUtils.readStringProperty(JoinProcessor.TYPE, processorTag, config, "separator");
            String targetField = ConfigurationUtils.readStringProperty(JoinProcessor.TYPE, processorTag, config, "target_field", field);
            return new JoinProcessor(processorTag, description, field, separator, targetField);
        }
    }
}

