/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.ExponentiallyWeightedMovingRate;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.SearchStatsSettings;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.SearchContext;

public final class ShardSearchStats
implements SearchOperationListener {
    private final StatsHolder totalStats;
    private final CounterMetric openContexts = new CounterMetric();
    private volatile Map<String, StatsHolder> groupsStats = Collections.emptyMap();
    private final SearchStatsSettings searchStatsSettings;

    public ShardSearchStats(SearchStatsSettings searchStatsSettings) {
        this.searchStatsSettings = searchStatsSettings;
        this.totalStats = new StatsHolder(searchStatsSettings);
    }

    public SearchStats stats(String ... groups) {
        Map<String, SearchStats.Stats> groupsSt;
        SearchStats.Stats total;
        block4: {
            total = this.totalStats.stats();
            groupsSt = null;
            if (CollectionUtils.isEmpty(groups)) break block4;
            groupsSt = Maps.newMapWithExpectedSize(this.groupsStats.size());
            if (groups.length == 1 && groups[0].equals("_all")) {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            } else {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    if (!Regex.simpleMatch(groups, entry.getKey())) continue;
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            }
        }
        return new SearchStats(total, this.openContexts.count(), groupsSt);
    }

    @Override
    public void onPreQueryPhase(SearchContext searchContext) {
        this.computeStats(searchContext, searchContext.hasOnlySuggest() ? statsHolder -> statsHolder.suggestCurrent.inc() : statsHolder -> statsHolder.queryCurrent.inc());
    }

    @Override
    public void onFailedQueryPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> {
            if (searchContext.hasOnlySuggest()) {
                statsHolder.suggestCurrent.dec();
            } else {
                statsHolder.queryCurrent.dec();
                statsHolder.queryFailure.inc();
            }
        });
    }

    @Override
    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        this.computeStats(searchContext, searchContext.hasOnlySuggest() ? statsHolder -> {
            statsHolder.recentSearchLoad.addIncrement(tookInNanos, System.nanoTime());
            statsHolder.suggestMetric.inc(tookInNanos);
            statsHolder.suggestCurrent.dec();
        } : statsHolder -> {
            statsHolder.recentSearchLoad.addIncrement(tookInNanos, System.nanoTime());
            statsHolder.queryMetric.inc(tookInNanos);
            statsHolder.queryCurrent.dec();
        });
    }

    @Override
    public void onPreFetchPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> statsHolder.fetchCurrent.inc());
    }

    @Override
    public void onFailedFetchPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> {
            statsHolder.fetchCurrent.dec();
            statsHolder.fetchFailure.inc();
        });
    }

    @Override
    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        this.computeStats(searchContext, statsHolder -> {
            statsHolder.recentSearchLoad.addIncrement(tookInNanos, System.nanoTime());
            statsHolder.fetchMetric.inc(tookInNanos);
            statsHolder.fetchCurrent.dec();
        });
    }

    @Override
    public void onDfsPhase(SearchContext searchContext, long tookInNanos) {
        this.computeStats(searchContext, statsHolder -> statsHolder.recentSearchLoad.addIncrement(tookInNanos, System.nanoTime()));
    }

    private void computeStats(SearchContext searchContext, Consumer<StatsHolder> consumer) {
        consumer.accept(this.totalStats);
        List<String> groupStats = searchContext.groupStats();
        if (groupStats != null) {
            for (String group : groupStats) {
                consumer.accept(this.groupStats(group));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsHolder groupStats(String group) {
        StatsHolder stats = this.groupsStats.get(group);
        if (stats == null) {
            ShardSearchStats shardSearchStats = this;
            synchronized (shardSearchStats) {
                stats = this.groupsStats.get(group);
                if (stats == null) {
                    stats = new StatsHolder(this.searchStatsSettings);
                    this.groupsStats = Maps.copyMapWithAddedEntry(this.groupsStats, group, stats);
                }
            }
        }
        return stats;
    }

    @Override
    public void onNewReaderContext(ReaderContext readerContext) {
        this.openContexts.inc();
    }

    @Override
    public void onFreeReaderContext(ReaderContext readerContext) {
        this.openContexts.dec();
    }

    @Override
    public void onNewScrollContext(ReaderContext readerContext) {
        this.totalStats.scrollCurrent.inc();
    }

    @Override
    public void onFreeScrollContext(ReaderContext readerContext) {
        this.totalStats.scrollCurrent.dec();
        assert (this.totalStats.scrollCurrent.count() >= 0L);
        this.totalStats.scrollMetric.inc(TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - readerContext.getStartTimeInNano()));
    }

    static final class StatsHolder {
        final MeanMetric queryMetric = new MeanMetric();
        final MeanMetric fetchMetric = new MeanMetric();
        final MeanMetric scrollMetric = new MeanMetric();
        final MeanMetric suggestMetric = new MeanMetric();
        final CounterMetric queryCurrent = new CounterMetric();
        final CounterMetric fetchCurrent = new CounterMetric();
        final CounterMetric scrollCurrent = new CounterMetric();
        final CounterMetric suggestCurrent = new CounterMetric();
        final CounterMetric queryFailure = new CounterMetric();
        final CounterMetric fetchFailure = new CounterMetric();
        final ExponentiallyWeightedMovingRate recentSearchLoad;

        StatsHolder(SearchStatsSettings searchStatsSettings) {
            double lambdaInInverseNanos = Math.log(2.0) / (double)searchStatsSettings.getRecentReadLoadHalfLifeForNewShards().nanos();
            this.recentSearchLoad = new ExponentiallyWeightedMovingRate(lambdaInInverseNanos, System.nanoTime());
        }

        SearchStats.Stats stats() {
            return new SearchStats.Stats(this.queryMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.queryMetric.sum()), this.queryCurrent.count(), this.queryFailure.count(), this.fetchMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.fetchMetric.sum()), this.fetchCurrent.count(), this.fetchFailure.count(), this.scrollMetric.count(), TimeUnit.MICROSECONDS.toMillis(this.scrollMetric.sum()), this.scrollCurrent.count(), this.suggestMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.suggestMetric.sum()), this.suggestCurrent.count(), this.recentSearchLoad.getRate(System.nanoTime()));
        }
    }
}

