/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.function.RandomScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RandomScoreFunctionBuilder
extends ScoreFunctionBuilder<RandomScoreFunctionBuilder> {
    public static final String NAME = "random_score";
    private String field;
    private Integer seed;

    public RandomScoreFunctionBuilder() {
    }

    public RandomScoreFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.seed = in.readInt();
        }
        this.field = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.seed != null) {
            out.writeBoolean(true);
            out.writeInt(this.seed);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.field);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public RandomScoreFunctionBuilder seed(int seed) {
        this.seed = seed;
        return this;
    }

    public RandomScoreFunctionBuilder seed(long seed) {
        this.seed = RandomScoreFunctionBuilder.hash(seed);
        return this;
    }

    public RandomScoreFunctionBuilder seed(String seed) {
        if (seed == null) {
            throw new IllegalArgumentException("random_score function: seed must not be null");
        }
        this.seed = seed.hashCode();
        return this;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public RandomScoreFunctionBuilder setField(String field) {
        this.field = field;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.seed != null) {
            builder.field("seed", this.seed);
        }
        if (this.field != null) {
            builder.field("field", this.field);
        }
        builder.endObject();
    }

    @Override
    protected boolean doEquals(RandomScoreFunctionBuilder functionBuilder) {
        return Objects.equals(this.seed, functionBuilder.seed);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.seed);
    }

    @Override
    protected ScoreFunction doToFunction(SearchExecutionContext context) {
        int salt = context.index().getName().hashCode() << 10 | context.getShardId();
        if (this.seed == null) {
            return new RandomScoreFunction(RandomScoreFunctionBuilder.hash(context.nowInMillis()), salt, null);
        }
        String fieldName = Objects.requireNonNullElse(this.field, "_seq_no");
        if (!context.isFieldMapped(fieldName)) {
            if (!context.hasMappings()) {
                return new RandomScoreFunction(RandomScoreFunctionBuilder.hash(context.nowInMillis()), salt, null);
            }
            throw new IllegalArgumentException("Field [" + this.field + "] is not mapped on [" + String.valueOf(context.index()) + "] and cannot be used as a source of random numbers.");
        }
        int seed = this.seed == null ? RandomScoreFunctionBuilder.hash(context.nowInMillis()) : this.seed;
        return new RandomScoreFunction(seed, salt, (IndexFieldData<?>)context.getForField(context.getFieldType(fieldName), MappedFieldType.FielddataOperation.SEARCH));
    }

    private static int hash(long value) {
        return Long.hashCode(value);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    public static RandomScoreFunctionBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        RandomScoreFunctionBuilder randomScoreFunctionBuilder = new RandomScoreFunctionBuilder();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("seed".equals(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (parser.numberType() == XContentParser.NumberType.INT) {
                        randomScoreFunctionBuilder.seed(parser.intValue());
                        continue;
                    }
                    if (parser.numberType() == XContentParser.NumberType.LONG) {
                        randomScoreFunctionBuilder.seed(parser.longValue());
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "random_score seed must be an int, long or string, not '" + token.toString() + "'", new Object[0]);
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    randomScoreFunctionBuilder.seed(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "random_score seed must be an int/long or string, not '" + token.toString() + "'", new Object[0]);
            }
            if ("field".equals(currentFieldName)) {
                randomScoreFunctionBuilder.setField(parser.text());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "random_score query does not support [" + currentFieldName + "]", new Object[0]);
        }
        return randomScoreFunctionBuilder;
    }
}

