/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;

public interface LeafFieldData
extends Accountable,
Releasable {
    public DocValuesScriptFieldFactory getScriptFieldFactory(String var1);

    public SortedBinaryDocValues getBytesValues();

    @Override
    default public void close() {
    }

    default public FormattedDocValues getFormattedValues(final DocValueFormat format) {
        final SortedBinaryDocValues values = this.getBytesValues();
        return new FormattedDocValues(){

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }
}

