/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.codec.vectors.diskbbq.CentroidAssignments;
import org.elasticsearch.index.codec.vectors.diskbbq.CentroidSupplier;

public abstract class IVFVectorsWriter
extends KnnVectorsWriter {
    private final List<FieldWriter> fieldWriters = new ArrayList<FieldWriter>();
    private final IndexOutput ivfCentroids;
    private final IndexOutput ivfClusters;
    private final IndexOutput ivfMeta;
    private final String rawVectorFormatName;
    private final FlatVectorsWriter rawVectorDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IVFVectorsWriter(SegmentWriteState state, String rawVectorFormatName, FlatVectorsWriter rawVectorDelegate) throws IOException {
        this.rawVectorFormatName = rawVectorFormatName;
        this.rawVectorDelegate = rawVectorDelegate;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "mivf");
        String ivfCentroidsFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "cenivf");
        String ivfClustersFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "clivf");
        boolean success = false;
        try {
            this.ivfMeta = state.directory.createOutput(metaFileName, state.context);
            CodecUtil.writeIndexHeader(this.ivfMeta, "ES920DiskBBQVectorsFormat", 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.ivfCentroids = state.directory.createOutput(ivfCentroidsFileName, state.context);
            CodecUtil.writeIndexHeader(this.ivfCentroids, "ES920DiskBBQVectorsFormat", 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.ivfClusters = state.directory.createOutput(ivfClustersFileName, state.context);
            CodecUtil.writeIndexHeader(this.ivfClusters, "ES920DiskBBQVectorsFormat", 0, state.segmentInfo.getId(), state.segmentSuffix);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this);
            }
        }
    }

    @Override
    public final KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            throw new IllegalArgumentException("IVF does not support cosine similarity");
        }
        KnnFieldVectorsWriter rawVectorDelegate = this.rawVectorDelegate.addField(fieldInfo);
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            KnnFieldVectorsWriter floatWriter = rawVectorDelegate;
            this.fieldWriters.add(new FieldWriter(fieldInfo, (FlatFieldVectorsWriter<float[]>)floatWriter));
        } else {
            this.fieldWriters.add(new FieldWriter(fieldInfo, null));
        }
        return rawVectorDelegate;
    }

    abstract CentroidAssignments calculateCentroids(FieldInfo var1, FloatVectorValues var2, float[] var3) throws IOException;

    abstract void writeCentroids(FieldInfo var1, CentroidSupplier var2, float[] var3, CentroidOffsetAndLength var4, IndexOutput var5) throws IOException;

    abstract CentroidOffsetAndLength buildAndWritePostingsLists(FieldInfo var1, CentroidSupplier var2, FloatVectorValues var3, IndexOutput var4, long var5, int[] var7, int[] var8) throws IOException;

    abstract CentroidOffsetAndLength buildAndWritePostingsLists(FieldInfo var1, CentroidSupplier var2, FloatVectorValues var3, IndexOutput var4, long var5, MergeState var7, int[] var8, int[] var9) throws IOException;

    abstract CentroidSupplier createCentroidSupplier(IndexInput var1, int var2, FieldInfo var3, float[] var4) throws IOException;

    @Override
    public final void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.rawVectorDelegate.flush(maxDoc, sortMap);
        for (FieldWriter fieldWriter : this.fieldWriters) {
            if (fieldWriter.delegate == null) {
                this.writeMeta(fieldWriter.fieldInfo, 0, 0L, 0L, 0L, 0L, null);
                continue;
            }
            float[] globalCentroid = new float[fieldWriter.fieldInfo.getVectorDimension()];
            FloatVectorValues floatVectorValues = IVFVectorsWriter.getFloatVectorValues(fieldWriter.fieldInfo, fieldWriter.delegate, maxDoc);
            CentroidAssignments centroidAssignments = this.calculateCentroids(fieldWriter.fieldInfo, floatVectorValues, globalCentroid);
            CentroidSupplier centroidSupplier = CentroidSupplier.fromArray(centroidAssignments.centroids());
            long postingListOffset = this.ivfClusters.alignFilePointer(4);
            CentroidOffsetAndLength centroidOffsetAndLength = this.buildAndWritePostingsLists(fieldWriter.fieldInfo, centroidSupplier, floatVectorValues, this.ivfClusters, postingListOffset, centroidAssignments.assignments(), centroidAssignments.overspillAssignments());
            long postingListLength = this.ivfClusters.getFilePointer() - postingListOffset;
            long centroidOffset = this.ivfCentroids.alignFilePointer(4);
            this.writeCentroids(fieldWriter.fieldInfo, centroidSupplier, globalCentroid, centroidOffsetAndLength, this.ivfCentroids);
            long centroidLength = this.ivfCentroids.getFilePointer() - centroidOffset;
            this.writeMeta(fieldWriter.fieldInfo, centroidSupplier.size(), centroidOffset, centroidLength, postingListOffset, postingListLength, globalCentroid);
        }
    }

    private static FloatVectorValues getFloatVectorValues(final FieldInfo fieldInfo, FlatFieldVectorsWriter<float[]> fieldVectorsWriter, int maxDoc) throws IOException {
        final List<float[]> vectors = fieldVectorsWriter.getVectors();
        if (vectors.size() == maxDoc) {
            return FloatVectorValues.fromFloats(vectors, fieldInfo.getVectorDimension());
        }
        DocIdSetIterator iterator = fieldVectorsWriter.getDocsWithFieldSet().iterator();
        final int[] docIds = new int[vectors.size()];
        for (int i = 0; i < docIds.length; ++i) {
            docIds[i] = iterator.nextDoc();
        }
        assert (iterator.nextDoc() == Integer.MAX_VALUE);
        return new FloatVectorValues(){

            @Override
            public float[] vectorValue(int ord) {
                return (float[])vectors.get(ord);
            }

            @Override
            public FloatVectorValues copy() {
                return this;
            }

            @Override
            public int dimension() {
                return fieldInfo.getVectorDimension();
            }

            @Override
            public int size() {
                return vectors.size();
            }

            @Override
            public int ordToDoc(int ord) {
                return docIds[ord];
            }
        };
    }

    @Override
    public final void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            this.mergeOneFieldIVF(fieldInfo, mergeState);
        } else {
            this.writeMeta(fieldInfo, 0, 0L, 0L, 0L, 0L, null);
        }
        this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
    }

    /*
     * Exception decompiling
     */
    @SuppressForbidden(reason="require usage of Lucene's IOUtils#deleteFilesIgnoringExceptions(...)")
    private void mergeOneFieldIVF(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static FloatVectorValues getFloatVectorValues(final FieldInfo fieldInfo, IndexInput docs, final IndexInput vectors, final int numVectors) throws IOException {
        if (numVectors == 0) {
            return FloatVectorValues.fromFloats(List.of(), fieldInfo.getVectorDimension());
        }
        final long vectorLength = 4L * (long)fieldInfo.getVectorDimension();
        final float[] vector = new float[fieldInfo.getVectorDimension()];
        final RandomAccessInput randomDocs = docs == null ? null : docs.randomAccessSlice(0L, docs.length());
        return new FloatVectorValues(){

            @Override
            public float[] vectorValue(int ord) throws IOException {
                vectors.seek((long)ord * vectorLength);
                vectors.readFloats(vector, 0, vector.length);
                return vector;
            }

            @Override
            public FloatVectorValues copy() {
                return this;
            }

            @Override
            public int dimension() {
                return fieldInfo.getVectorDimension();
            }

            @Override
            public int size() {
                return numVectors;
            }

            @Override
            public int ordToDoc(int ord) {
                if (randomDocs == null) {
                    return ord;
                }
                try {
                    return randomDocs.readInt((long)ord * 4L);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    private static int writeFloatVectorValues(FieldInfo fieldInfo, IndexOutput docsOut, IndexOutput vectorsOut, FloatVectorValues floatVectorValues) throws IOException {
        int numVectors = 0;
        ByteBuffer buffer = ByteBuffer.allocate(fieldInfo.getVectorDimension() * 4).order(ByteOrder.LITTLE_ENDIAN);
        KnnVectorValues.DocIndexIterator iterator = floatVectorValues.iterator();
        int docV = iterator.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            ++numVectors;
            buffer.asFloatBuffer().put(floatVectorValues.vectorValue(iterator.index()));
            vectorsOut.writeBytes(buffer.array(), buffer.array().length);
            if (docsOut != null) {
                docsOut.writeInt(iterator.docID());
            }
            docV = iterator.nextDoc();
        }
        return numVectors;
    }

    private void writeMeta(FieldInfo field, int numCentroids, long centroidOffset, long centroidLength, long postingListOffset, long postingListLength, float[] globalCentroid) throws IOException {
        this.ivfMeta.writeInt(field.number);
        this.ivfMeta.writeString(this.rawVectorFormatName);
        this.ivfMeta.writeInt(field.getVectorEncoding().ordinal());
        this.ivfMeta.writeInt(IVFVectorsWriter.distFuncToOrd(field.getVectorSimilarityFunction()));
        this.ivfMeta.writeInt(numCentroids);
        this.ivfMeta.writeLong(centroidOffset);
        this.ivfMeta.writeLong(centroidLength);
        if (centroidLength > 0L) {
            this.ivfMeta.writeLong(postingListOffset);
            this.ivfMeta.writeLong(postingListLength);
            ByteBuffer buffer = ByteBuffer.allocate(globalCentroid.length * 4).order(ByteOrder.LITTLE_ENDIAN);
            buffer.asFloatBuffer().put(globalCentroid);
            this.ivfMeta.writeBytes(buffer.array(), buffer.array().length);
            this.ivfMeta.writeInt(Float.floatToIntBits(VectorUtil.dotProduct(globalCentroid, globalCentroid)));
        }
    }

    private static int distFuncToOrd(VectorSimilarityFunction func) {
        for (int i = 0; i < Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.size(); ++i) {
            if (!Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.get(i).equals((Object)func)) continue;
            return (byte)i;
        }
        throw new IllegalArgumentException("invalid distance function: " + String.valueOf((Object)func));
    }

    @Override
    public final void finish() throws IOException {
        this.rawVectorDelegate.finish();
        if (this.ivfMeta != null) {
            this.ivfMeta.writeInt(-1);
            CodecUtil.writeFooter(this.ivfMeta);
        }
        if (this.ivfCentroids != null) {
            CodecUtil.writeFooter(this.ivfCentroids);
        }
        if (this.ivfClusters != null) {
            CodecUtil.writeFooter(this.ivfClusters);
        }
    }

    @Override
    public final void close() throws IOException {
        IOUtils.close(this.rawVectorDelegate, this.ivfMeta, this.ivfCentroids, this.ivfClusters);
    }

    @Override
    public final long ramBytesUsed() {
        return this.rawVectorDelegate.ramBytesUsed();
    }

    private record FieldWriter(FieldInfo fieldInfo, FlatFieldVectorsWriter<float[]> delegate) {
    }

    record CentroidOffsetAndLength(LongValues offsets, LongValues lengths) {
    }
}

