/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.codec.FieldInfosWithUsages;
import org.elasticsearch.index.mapper.FieldMapper;

public final class DeduplicatingFieldInfosFormat
extends FieldInfosFormat {
    private static final Map<Map<String, String>, Map<String, String>> attributeDeduplicator = ConcurrentCollections.newConcurrentMap();
    private static final StringLiteralDeduplicator attributesDeduplicator = new StringLiteralDeduplicator();
    private final FieldInfosFormat delegate;

    public DeduplicatingFieldInfosFormat(FieldInfosFormat delegate) {
        this.delegate = delegate;
    }

    @Override
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos = this.delegate.read(directory, segmentInfo, segmentSuffix, iocontext);
        FieldInfo[] deduplicated = new FieldInfo[fieldInfos.size()];
        int i = 0;
        for (FieldInfo fi : fieldInfos) {
            deduplicated[i++] = new FieldInfo(FieldMapper.internFieldName(fi.getName()), fi.number, fi.hasTermVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), fi.docValuesSkipIndexType(), fi.getDocValuesGen(), DeduplicatingFieldInfosFormat.internStringStringMap(fi.attributes()), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction(), fi.isSoftDeletesField(), fi.isParentField());
        }
        return new FieldInfosWithUsages(deduplicated);
    }

    private static Map<String, String> internStringStringMap(Map<String, String> m) {
        if (m.size() > 10) {
            return m;
        }
        Map<String, String> res = attributeDeduplicator.get(m);
        if (res == null) {
            if (attributeDeduplicator.size() > 100) {
                attributeDeduplicator.clear();
            }
            Map interned = Maps.newHashMapWithExpectedSize(m.size());
            m.forEach((key, value) -> interned.put(attributesDeduplicator.deduplicate((String)key), attributesDeduplicator.deduplicate((String)value)));
            res = Map.copyOf(interned);
            attributeDeduplicator.put(res, res);
        }
        return res;
    }

    @Override
    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        this.delegate.write(directory, segmentInfo, segmentSuffix, infos, context);
    }
}

