/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record DslErrorInfo(String indexName, long firstOccurrence, int retryCount, ProjectId projectId) implements Writeable
{
    public DslErrorInfo(String indexName, long firstOccurrence, int retryCount) {
        this(indexName, firstOccurrence, retryCount, ProjectId.DEFAULT);
    }

    public DslErrorInfo(StreamInput in) throws IOException {
        this(in.readString(), in.readLong(), in.readVInt(), in.getTransportVersion().onOrAfter(TransportVersions.ADD_PROJECT_ID_TO_DSL_ERROR_INFO) ? ProjectId.readFrom(in) : ProjectId.DEFAULT);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeLong(this.firstOccurrence);
        out.writeVInt(this.retryCount);
        if (out.getTransportVersion().onOrAfter(TransportVersions.ADD_PROJECT_ID_TO_DSL_ERROR_INFO)) {
            this.projectId.writeTo(out);
        }
    }
}

