/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.elasticsearch.grok.FloatConsumer;
import org.elasticsearch.grok.GrokCaptureExtracter;
import org.elasticsearch.grok.GrokCaptureType;
import org.elasticsearch.grok.shaded.org.joni.NameEntry;

public final class GrokCaptureConfig {
    private final String name;
    private final GrokCaptureType type;
    private final int[] backRefs;

    GrokCaptureConfig(NameEntry nameEntry) {
        String groupName = new String(nameEntry.name, nameEntry.nameP, nameEntry.nameEnd - nameEntry.nameP, StandardCharsets.UTF_8);
        String[] parts = groupName.split(":");
        this.name = parts.length >= 2 ? parts[1] : parts[0];
        this.type = parts.length == 3 ? GrokCaptureType.fromString(parts[2]) : GrokCaptureType.STRING;
        this.backRefs = nameEntry.getBackRefs();
    }

    public String name() {
        return this.name;
    }

    public GrokCaptureType type() {
        return this.type;
    }

    public GrokCaptureExtracter objectExtracter(final Consumer<Object> emit) {
        return this.nativeExtracter(new NativeExtracterMap<GrokCaptureExtracter>(){

            @Override
            public GrokCaptureExtracter forString(Function<Consumer<String>, GrokCaptureExtracter> buildExtracter) {
                return buildExtracter.apply(str -> emit.accept(str));
            }

            @Override
            public GrokCaptureExtracter forInt(Function<IntConsumer, GrokCaptureExtracter> buildExtracter) {
                return buildExtracter.apply(i -> emit.accept(i));
            }

            @Override
            public GrokCaptureExtracter forLong(Function<LongConsumer, GrokCaptureExtracter> buildExtracter) {
                return buildExtracter.apply(l -> emit.accept(l));
            }

            @Override
            public GrokCaptureExtracter forFloat(Function<FloatConsumer, GrokCaptureExtracter> buildExtracter) {
                return buildExtracter.apply(f -> emit.accept(Float.valueOf(f)));
            }

            @Override
            public GrokCaptureExtracter forDouble(Function<DoubleConsumer, GrokCaptureExtracter> buildExtracter) {
                return buildExtracter.apply(d -> emit.accept(d));
            }

            @Override
            public GrokCaptureExtracter forBoolean(Function<Consumer<Boolean>, GrokCaptureExtracter> buildExtracter) {
                return buildExtracter.apply(b -> emit.accept(b));
            }
        });
    }

    public <T> T nativeExtracter(NativeExtracterMap<T> map) {
        return this.type.nativeExtracter(this.backRefs, map);
    }

    public GrokCaptureExtracter rangeExtracter(Consumer<Object> emit) {
        return (utf8Bytes, offset, region) -> {
            for (int number : this.backRefs) {
                if (region.beg[number] < 0) continue;
                int matchOffset = offset + region.beg[number];
                int matchLength = region.end[number] - region.beg[number];
                String match = new String(utf8Bytes, matchOffset, matchLength, StandardCharsets.UTF_8);
                emit.accept(new GrokCaptureExtracter.Range(match, matchOffset, matchLength));
            }
        };
    }

    public static interface NativeExtracterMap<T> {
        public T forString(Function<Consumer<String>, GrokCaptureExtracter> var1);

        public T forInt(Function<IntConsumer, GrokCaptureExtracter> var1);

        public T forLong(Function<LongConsumer, GrokCaptureExtracter> var1);

        public T forFloat(Function<FloatConsumer, GrokCaptureExtracter> var1);

        public T forDouble(Function<DoubleConsumer, GrokCaptureExtracter> var1);

        public T forBoolean(Function<Consumer<Boolean>, GrokCaptureExtracter> var1);
    }
}

