/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureClusterStateSettings;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.xcontent.ToXContent;

public class ClusterSecrets
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "cluster_state_secrets";
    private final SecureClusterStateSettings settings;
    private final long version;

    public ClusterSecrets(long version, SecureClusterStateSettings settings) {
        this.version = version;
        this.settings = settings;
    }

    public ClusterSecrets(StreamInput in) throws IOException {
        this.version = in.readLong();
        this.settings = new SecureClusterStateSettings(in);
    }

    public SecureSettings getSettings() {
        return new SecureClusterStateSettings(this.settings);
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public boolean isPrivate() {
        return true;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Collections.emptyIterator();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_9_X;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        this.settings.writeTo(out);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return ClusterSecrets.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public String toString() {
        return "ClusterStateSecrets{[all secret]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSecrets that = (ClusterSecrets)o;
        return this.version == that.version && Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.version);
    }
}

