/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.IntSupplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptTermStats;
import org.elasticsearch.search.lookup.SearchLookup;

public class ScriptScoreQuery
extends Query {
    private final Query subQuery;
    private final Script script;
    private final ScoreScript.LeafFactory scriptBuilder;
    private final SearchLookup lookup;
    private final Float minScore;
    private final String indexName;
    private final int shardId;
    private final IndexVersion indexVersion;

    public ScriptScoreQuery(Query subQuery, Script script, ScoreScript.LeafFactory scriptBuilder, SearchLookup lookup, Float minScore, String indexName, int shardId, IndexVersion indexVersion) {
        this.subQuery = subQuery;
        this.script = script;
        this.scriptBuilder = scriptBuilder;
        this.lookup = lookup;
        this.minScore = minScore;
        this.indexName = indexName;
        this.shardId = shardId;
        this.indexVersion = indexVersion;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    @Override
    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query newQ = this.subQuery.rewrite(searcher);
        if (newQ != this.subQuery) {
            return new ScriptScoreQuery(newQ, this.script, this.scriptBuilder, this.lookup, this.minScore, this.indexName, this.shardId, this.indexVersion);
        }
        return super.rewrite(searcher);
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (scoreMode == ScoreMode.COMPLETE_NO_SCORES && this.minScore == null) {
            return this.subQuery.createWeight(searcher, scoreMode, boost);
        }
        final boolean needsScore = this.scriptBuilder.needs_score();
        final boolean needsTermStatistics = this.scriptBuilder.needs_termStats();
        final ScoreMode subQueryScoreMode = needsScore || needsTermStatistics ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        final Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryScoreMode, 1.0f);
        final HashSet<Term> terms = new HashSet<Term>();
        if (needsTermStatistics) {
            this.visit(QueryVisitor.termCollector(terms));
        }
        return new Weight(this){

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final ScorerSupplier subQueryScorerSupplier = subQueryWeight.scorerSupplier(context);
                if (subQueryScorerSupplier == null) {
                    return null;
                }
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        Scorer subQueryScorer = subQueryScorerSupplier.get(leadCost);
                        Scorer scriptScorer = new ScriptScorer(this.makeScoreScript(context), subQueryScorer, subQueryScoreMode, boost, null);
                        if (ScriptScoreQuery.this.minScore != null) {
                            scriptScorer = new MinScoreScorer(scriptScorer, ScriptScoreQuery.this.minScore.floatValue());
                        }
                        return scriptScorer;
                    }

                    @Override
                    public BulkScorer bulkScorer() throws IOException {
                        if (ScriptScoreQuery.this.minScore == null) {
                            BulkScorer subQueryBulkScorer = subQueryScorerSupplier.bulkScorer();
                            return new ScriptScoreBulkScorer(subQueryBulkScorer, subQueryScoreMode, this.makeScoreScript(context), boost);
                        }
                        return super.bulkScorer();
                    }

                    @Override
                    public long cost() {
                        return subQueryScorerSupplier.cost();
                    }
                };
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation subQueryExplanation = subQueryWeight.explain(context, doc);
                if (!subQueryExplanation.isMatch()) {
                    return subQueryExplanation;
                }
                ScoreScript.ExplanationHolder explanationHolder = new ScoreScript.ExplanationHolder();
                ScriptScorer scorer = new ScriptScorer(this.makeScoreScript(context), subQueryWeight.scorer(context), subQueryScoreMode, 1.0f, explanationHolder);
                int newDoc = ((Scorer)scorer).iterator().advance(doc);
                assert (doc == newDoc);
                float score = ((Scorable)scorer).score();
                Explanation explanation = explanationHolder.get(score, needsScore ? subQueryExplanation : null);
                if (explanation == null) {
                    String desc = "script score function, computed with script:\"" + String.valueOf(ScriptScoreQuery.this.script) + "\"";
                    if (needsScore) {
                        Explanation scoreExp = Explanation.match(subQueryExplanation.getValue(), "_score: ", subQueryExplanation);
                        explanation = Explanation.match((Number)Float.valueOf(score), desc, scoreExp);
                    } else {
                        explanation = Explanation.match((Number)Float.valueOf(score), desc, new Explanation[0]);
                    }
                }
                if (boost != 1.0f) {
                    explanation = Explanation.match((Number)Float.valueOf(boost * explanation.getValue().floatValue()), "Boosted score, product of:", Explanation.match((Number)Float.valueOf(boost), "boost", new Explanation[0]), explanation);
                }
                if (ScriptScoreQuery.this.minScore != null && ScriptScoreQuery.this.minScore.floatValue() > explanation.getValue().floatValue()) {
                    explanation = Explanation.noMatch("Score value is too low, expected at least " + ScriptScoreQuery.this.minScore + " but got " + String.valueOf(explanation.getValue()), explanation);
                }
                return explanation;
            }

            private ScoreScript makeScoreScript(LeafReaderContext context) throws IOException {
                ScoreScript scoreScript = ScriptScoreQuery.this.scriptBuilder.newInstance(new DocValuesDocReader(ScriptScoreQuery.this.lookup, context));
                scoreScript._setIndexName(ScriptScoreQuery.this.indexName);
                scoreScript._setShard(ScriptScoreQuery.this.shardId);
                if (needsTermStatistics) {
                    scoreScript._setTermStats(new ScriptTermStats(searcher, context, scoreScript::_getDocId, terms));
                }
                return scoreScript;
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.subQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public String toString(String field) {
        return "script_score (" + this.subQuery.toString(field) + ", script: {" + this.script.toString() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        ScriptScoreQuery that = (ScriptScoreQuery)o;
        return this.shardId == that.shardId && this.subQuery.equals(that.subQuery) && this.script.equals(that.script) && Objects.equals(this.minScore, that.minScore) && this.indexName.equals(that.indexName) && this.indexVersion.equals(that.indexVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.subQuery, this.script, this.minScore, this.indexName, this.shardId, this.indexVersion);
    }

    public boolean needsScore() {
        return this.scriptBuilder.needs_score();
    }

    public ScriptScoreQuery cloneWithNewSubQuery(Query newSubQuery) {
        return new ScriptScoreQuery(newSubQuery, this.script, this.scriptBuilder, this.lookup, this.minScore, this.indexName, this.shardId, this.indexVersion);
    }

    private static class ScriptScoreBulkScorer
    extends BulkScorer {
        private final BulkScorer subQueryBulkScorer;
        private final ScoreMode subQueryScoreMode;
        private final ScoreScript scoreScript;
        private final float boost;

        ScriptScoreBulkScorer(BulkScorer subQueryBulkScorer, ScoreMode subQueryScoreMode, ScoreScript scoreScript, float boost) {
            this.subQueryBulkScorer = subQueryBulkScorer;
            this.subQueryScoreMode = subQueryScoreMode;
            this.scoreScript = scoreScript;
            this.boost = boost;
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            return this.subQueryBulkScorer.score(this.wrapCollector(collector), acceptDocs, min, max);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){
                private int docID;

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    this.in.setScorer(new ScriptScorable(scoreScript, scorer, subQueryScoreMode, boost, () -> this.docID));
                }

                @Override
                public void collect(int doc) throws IOException {
                    this.docID = doc;
                    super.collect(doc);
                }
            };
        }

        @Override
        public long cost() {
            return this.subQueryBulkScorer.cost();
        }
    }

    private static class ScriptScorable
    extends Scorable {
        private final ScoreScript scoreScript;
        private final Scorable subQueryScorer;
        private final float boost;
        private final IntSupplier docIDSupplier;

        ScriptScorable(ScoreScript scoreScript, Scorable subQueryScorer, ScoreMode subQueryScoreMode, float boost, IntSupplier docIDSupplier) {
            this.scoreScript = scoreScript;
            if (subQueryScoreMode == ScoreMode.COMPLETE) {
                scoreScript.setScorer(subQueryScorer);
            }
            this.subQueryScorer = subQueryScorer;
            this.boost = boost;
            this.docIDSupplier = docIDSupplier;
        }

        @Override
        public float score() throws IOException {
            int docId = this.docIDSupplier.getAsInt();
            this.scoreScript.setDocument(docId);
            float score = (float)this.scoreScript.execute(null);
            if (score < 0.0f || Float.isNaN(score)) {
                throw new IllegalArgumentException("script_score script returned an invalid score [" + score + "] for doc [" + docId + "]. Must be a non-negative score!");
            }
            return score * this.boost;
        }
    }

    private static class ScriptScorer
    extends Scorer {
        private final ScoreScript scoreScript;
        private final Scorer subQueryScorer;
        private final float boost;
        private final ScoreScript.ExplanationHolder explanation;

        ScriptScorer(ScoreScript scoreScript, Scorer subQueryScorer, ScoreMode subQueryScoreMode, float boost, ScoreScript.ExplanationHolder explanation) {
            this.scoreScript = scoreScript;
            if (subQueryScoreMode == ScoreMode.COMPLETE) {
                scoreScript.setScorer(subQueryScorer);
            }
            this.subQueryScorer = subQueryScorer;
            this.boost = boost;
            this.explanation = explanation;
        }

        @Override
        public float score() throws IOException {
            int docId = this.docID();
            this.scoreScript.setDocument(docId);
            float score = (float)this.scoreScript.execute(this.explanation);
            if (score < 0.0f || Float.isNaN(score)) {
                throw new IllegalArgumentException("script_score script returned an invalid score [" + score + "] for doc [" + docId + "]. Must be a non-negative score!");
            }
            return score * this.boost;
        }

        @Override
        public int docID() {
            return this.subQueryScorer.docID();
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.subQueryScorer.iterator();
        }

        @Override
        public TwoPhaseIterator twoPhaseIterator() {
            return this.subQueryScorer.twoPhaseIterator();
        }

        @Override
        public float getMaxScore(int upTo) {
            return Float.MAX_VALUE;
        }
    }
}

