/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Locale;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.elasticsearch.common.logging.NodeAndClusterIdStateListener;

@Plugin(category="Converter", name="NodeAndClusterIdConverter")
@ConverterKeys(value={"node_and_cluster_id"})
@Deprecated
public final class NodeAndClusterIdConverter
extends LogEventPatternConverter {
    public NodeAndClusterIdConverter() {
        super("NodeAndClusterId", "node_and_cluster_id");
    }

    public static NodeAndClusterIdConverter newInstance(String[] options) {
        return new NodeAndClusterIdConverter();
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (NodeAndClusterIdStateListener.nodeAndClusterId.get() != null) {
            String nodeId = NodeAndClusterIdStateListener.nodeAndClusterId.get().v1();
            String clusterUUID = NodeAndClusterIdStateListener.nodeAndClusterId.get().v2();
            toAppendTo.append(NodeAndClusterIdConverter.formatIds(nodeId, clusterUUID));
        }
    }

    private static String formatIds(String nodeId, String clusterUUID) {
        return String.format(Locale.ROOT, "\"cluster.uuid\": \"%s\", \"node.id\": \"%s\"", clusterUUID, nodeId);
    }
}

