/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.XContentParser;

class XContentParserTsidFunnel
implements TsidBuilder.ThrowingTsidFunnel<XContentParser, IOException> {
    private static final XContentParserTsidFunnel INSTANCE = new XContentParserTsidFunnel();

    XContentParserTsidFunnel() {
    }

    static XContentParserTsidFunnel get() {
        return INSTANCE;
    }

    @Override
    public void add(XContentParser parser, TsidBuilder tsidBuilder) throws IOException {
        XContentParserUtils.ensureExpectedToken(null, parser.currentToken(), parser);
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Error extracting tsid: source didn't contain any dimension fields");
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
        this.extractObject(tsidBuilder, null, parser);
        XContentParserUtils.ensureExpectedToken(null, parser.nextToken(), parser);
    }

    private void extractObject(TsidBuilder tsidBuilder, @Nullable String path, XContentParser source) throws IOException {
        while (source.currentToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, source.currentToken(), source);
            String fieldName = source.currentName();
            String subPath = path == null ? fieldName : path + "." + fieldName;
            source.nextToken();
            this.extractItem(tsidBuilder, subPath, source);
        }
    }

    private void extractArray(TsidBuilder tsidBuilder, @Nullable String path, XContentParser source) throws IOException {
        while (source.currentToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.expectValueToken(source.currentToken(), source);
            this.extractItem(tsidBuilder, path, source);
        }
    }

    private void extractItem(TsidBuilder tsidBuilder, String path, XContentParser source) throws IOException {
        switch (source.currentToken()) {
            case START_OBJECT: {
                source.nextToken();
                this.extractObject(tsidBuilder, path, source);
                source.nextToken();
                break;
            }
            case VALUE_NUMBER: {
                switch (source.numberType()) {
                    case INT: {
                        tsidBuilder.addIntDimension(path, source.intValue());
                        break;
                    }
                    case LONG: {
                        tsidBuilder.addLongDimension(path, source.longValue());
                        break;
                    }
                    case FLOAT: {
                        tsidBuilder.addDoubleDimension(path, source.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        tsidBuilder.addDoubleDimension(path, source.doubleValue());
                        break;
                    }
                    case BIG_DECIMAL: 
                    case BIG_INTEGER: {
                        tsidBuilder.addStringDimension(path, source.optimizedText().bytes());
                    }
                }
                source.nextToken();
                break;
            }
            case VALUE_BOOLEAN: {
                tsidBuilder.addBooleanDimension(path, source.booleanValue());
                source.nextToken();
                break;
            }
            case VALUE_STRING: {
                tsidBuilder.addStringDimension(path, source.optimizedText().bytes());
                source.nextToken();
                break;
            }
            case START_ARRAY: {
                source.nextToken();
                this.extractArray(tsidBuilder, path, source);
                source.nextToken();
                break;
            }
            case VALUE_NULL: {
                source.nextToken();
                break;
            }
            default: {
                throw new ParsingException(source.getTokenLocation(), "Cannot extract dimension due to unexpected token [{}]", new Object[]{source.currentToken()});
            }
        }
    }
}

