/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.project;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedRunnable;

public abstract class AbstractProjectResolver
implements ProjectResolver {
    private final Supplier<ThreadContext> threadContext;

    public AbstractProjectResolver(Supplier<ThreadContext> threadContext) {
        this.threadContext = threadContext;
    }

    protected abstract ProjectId getFallbackProjectId();

    protected abstract boolean allowAccessToAllProjects(ThreadContext var1);

    @Override
    public ProjectId getProjectId() {
        String headerValue = this.getProjectIdFromThreadContext();
        if (headerValue == null) {
            return this.getFallbackProjectId();
        }
        return ProjectId.fromId(headerValue);
    }

    @Override
    public Collection<ProjectId> getProjectIds(ClusterState clusterState) {
        String headerValue = this.getProjectIdFromThreadContext();
        if (headerValue == null) {
            if (this.allowAccessToAllProjects(this.threadContext.get())) {
                return clusterState.metadata().projects().keySet();
            }
            throw new ElasticsearchSecurityException("No project id supplied, and not permitted to access all projects", new Object[0]);
        }
        return Set.of(AbstractProjectResolver.findProject(clusterState.metadata(), headerValue).id());
    }

    @Override
    public <E extends Exception> void executeOnProject(ProjectId projectId, CheckedRunnable<E> body) throws E {
        ThreadContext threadContext = this.threadContext.get();
        String existingProjectId = threadContext.getHeader("X-Elastic-Project-Id");
        if (existingProjectId != null) {
            throw new IllegalStateException("There is already a project-id [" + existingProjectId + "] in the thread-context, cannot set it to [" + String.valueOf(projectId) + "]");
        }
        try (ThreadContext.StoredContext ignoreAndRestore = threadContext.newStoredContext();){
            threadContext.putHeader("X-Elastic-Project-Id", projectId.id());
            body.run();
        }
    }

    @Override
    public boolean supportsMultipleProjects() {
        return true;
    }

    protected static ProjectMetadata findProject(Metadata metadata, String headerValue) {
        ProjectMetadata project = metadata.projects().get(ProjectId.fromId(headerValue));
        if (project == null) {
            throw new IllegalArgumentException("Could not find project with id [" + headerValue + "]");
        }
        return project;
    }

    protected String getProjectIdFromThreadContext() {
        return this.threadContext.get().getHeader("X-Elastic-Project-Id");
    }
}

