/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.synonyms.SynonymUpdateResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.synonyms.SynonymRule;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class PutSynonymsAction
extends ActionType<SynonymUpdateResponse> {
    public static final PutSynonymsAction INSTANCE = new PutSynonymsAction();
    public static final String NAME = "cluster:admin/synonyms/put";

    public PutSynonymsAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest {
        private final String synonymsSetId;
        private final SynonymRule[] synonymRules;
        private final boolean refresh;
        public static final ParseField SYNONYMS_SET_FIELD = new ParseField("synonyms_set", new String[0]);
        private static final ConstructingObjectParser<SynonymRule[], Void> PARSER = new ConstructingObjectParser("synonyms_set", args -> {
            List synonyms = (List)args[0];
            return synonyms.toArray(new SynonymRule[synonyms.size()]);
        });

        public Request(StreamInput in) throws IOException {
            super(in);
            this.synonymsSetId = in.readString();
            this.synonymRules = in.readArray(SynonymRule::new, SynonymRule[]::new);
            this.refresh = in.getTransportVersion().onOrAfter(TransportVersions.SYNONYMS_REFRESH_PARAM) ? in.readBoolean() : false;
        }

        public Request(String synonymsSetId, boolean refresh, BytesReference content, XContentType contentType) throws IOException {
            this.synonymsSetId = synonymsSetId;
            this.refresh = refresh;
            try (XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, content, contentType);){
                this.synonymRules = PARSER.apply(parser, null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse: " + content.utf8ToString(), e);
            }
        }

        Request(String synonymsSetId, SynonymRule[] synonymRules, boolean refresh) {
            this.synonymsSetId = synonymsSetId;
            this.synonymRules = synonymRules;
            this.refresh = refresh;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isEmpty(this.synonymsSetId)) {
                validationException = ValidateActions.addValidationError("synonyms set must be specified", validationException);
            }
            for (SynonymRule synonymRule : this.synonymRules) {
                String error = synonymRule.validate();
                if (error == null) continue;
                validationException = ValidateActions.addValidationError(error, validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.synonymsSetId);
            out.writeArray(this.synonymRules);
            if (out.getTransportVersion().onOrAfter(TransportVersions.SYNONYMS_REFRESH_PARAM)) {
                out.writeBoolean(this.refresh);
            }
        }

        public String synonymsSetId() {
            return this.synonymsSetId;
        }

        public boolean refresh() {
            return this.refresh;
        }

        public SynonymRule[] synonymRules() {
            return this.synonymRules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.refresh, request.refresh) && Objects.equals(this.synonymsSetId, request.synonymsSetId) && Arrays.equals(this.synonymRules, request.synonymRules);
        }

        public int hashCode() {
            return Objects.hash(this.synonymsSetId, Arrays.hashCode(this.synonymRules), this.refresh);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> SynonymRule.fromXContent(p), SYNONYMS_SET_FIELD);
        }
    }
}

