/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.rollover.TransportRolloverAction;
import org.elasticsearch.action.datastreams.autosharding.DataStreamAutoShardingService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionMultiListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class LazyRolloverAction
extends ActionType<RolloverResponse> {
    private static final Logger logger = LogManager.getLogger(LazyRolloverAction.class);
    public static final LazyRolloverAction INSTANCE = new LazyRolloverAction();
    public static final String NAME = "indices:admin/data_stream/lazy_rollover";

    private LazyRolloverAction() {
        super(NAME);
    }

    @Override
    public String name() {
        return NAME;
    }

    private static boolean isLazyRolloverNeeded(DataStream dataStream, boolean failureStore) {
        DataStream.DataStreamIndices indices = dataStream.getDataStreamIndices(failureStore);
        return indices.isRolloverOnWrite() || failureStore && indices.getIndices().isEmpty();
    }

    private static void notifyAllListeners(List<ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>> taskContexts, Consumer<ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>> onPublicationSuccess) {
        taskContexts.forEach(context -> context.success(() -> onPublicationSuccess.accept((ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>)context)));
    }

    private static RolloverResponse noopLazyRolloverResponse(DataStream.DataStreamIndices indices) {
        String latestWriteIndex = indices.getWriteIndex().getName();
        return new RolloverResponse(latestWriteIndex, latestWriteIndex, Map.of(), false, false, true, true, false);
    }

    record LazyRolloverExecutor(ClusterService clusterService, AllocationService allocationService, MetadataRolloverService rolloverService, ThreadPool threadPool) implements ClusterStateTaskExecutor<LazyRolloverTask>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<LazyRolloverTask> batchExecutionContext) {
            AllocationActionMultiListener<RolloverResponse> listener = new AllocationActionMultiListener<RolloverResponse>(this.threadPool.getThreadContext());
            StringBuilder reasonBuilder = new StringBuilder("lazy bulk rollover [");
            Strings.BoundedDelimitedStringCollector resultsCollector = new Strings.BoundedDelimitedStringCollector(reasonBuilder, ",", 1024);
            ClusterState state = batchExecutionContext.initialState();
            HashMap<ProjectId, Map> groupedRequests = new HashMap<ProjectId, Map>();
            for (ClusterStateTaskExecutor.TaskContext<LazyRolloverTask> taskContext2 : batchExecutionContext.taskContexts()) {
                groupedRequests.computeIfAbsent(taskContext2.getTask().projectId(), ignored -> new HashMap()).computeIfAbsent(taskContext2.getTask().rolloverRequest(), ignored -> new ArrayList()).add(taskContext2);
            }
            for (Map.Entry entry : groupedRequests.entrySet()) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    List rolloverTaskContexts = (List)entry2.getValue();
                    try {
                        RolloverRequest rolloverRequest = (RolloverRequest)entry2.getKey();
                        ProjectState projectState = state.projectState((ProjectId)entry.getKey());
                        state = this.executeTask(projectState, rolloverRequest, resultsCollector::appendItem, rolloverTaskContexts, listener);
                    }
                    catch (Exception e) {
                        rolloverTaskContexts.forEach(taskContext -> taskContext.onFailure(e));
                    }
                    finally {
                        rolloverTaskContexts.forEach(taskContext -> taskContext.captureResponseHeaders().close());
                    }
                }
            }
            if (state != batchExecutionContext.initialState()) {
                resultsCollector.finish();
                reasonBuilder.append(']');
                try (Releasable ignored2 = batchExecutionContext.dropHeadersContext();){
                    state = this.allocationService.reroute(state, reasonBuilder.toString(), listener.reroute());
                }
            } else {
                listener.noRerouteNeeded();
            }
            return state;
        }

        public ClusterState executeTask(ProjectState currentState, RolloverRequest rolloverRequest, Consumer<String> results, List<ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>> rolloverTaskContexts, AllocationActionMultiListener<RolloverResponse> allocationActionMultiListener) throws Exception {
            IndexNameExpressionResolver.ResolvedExpression resolvedRolloverTarget = IndexNameExpressionResolver.SelectorResolver.parseExpression(rolloverRequest.getRolloverTarget(), rolloverRequest.indicesOptions());
            boolean isFailureStoreRollover = resolvedRolloverTarget.selector() != null && resolvedRolloverTarget.selector().shouldIncludeFailures();
            DataStream dataStream = currentState.metadata().dataStreams().get(resolvedRolloverTarget.resource());
            assert (dataStream != null);
            if (!LazyRolloverAction.isLazyRolloverNeeded(dataStream, isFailureStoreRollover)) {
                DataStream.DataStreamIndices targetIndices = dataStream.getDataStreamIndices(isFailureStoreRollover);
                RolloverResponse noopResponse = LazyRolloverAction.noopLazyRolloverResponse(targetIndices);
                LazyRolloverAction.notifyAllListeners(rolloverTaskContexts, context -> ((LazyRolloverTask)context.getTask()).listener.onResponse(noopResponse));
                return currentState.cluster();
            }
            MetadataRolloverService.RolloverResult rolloverResult = this.rolloverService.rolloverClusterState(currentState, resolvedRolloverTarget.resource(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), List.of(), Instant.now(), false, false, null, null, isFailureStoreRollover);
            results.accept(rolloverResult.sourceIndexName() + "->" + rolloverResult.rolloverIndexName());
            logger.trace("lazy rollover result [{}]", (Object)rolloverResult);
            String rolloverIndexName = rolloverResult.rolloverIndexName();
            String sourceIndexName = rolloverResult.sourceIndexName();
            logger.info("rolling over data stream [{}] to index [{}] because it was marked for lazy rollover", (Object)dataStream.getName(), (Object)rolloverIndexName);
            TimeValue waitForActiveShardsTimeout = rolloverRequest.masterNodeTimeout().millis() < 0L ? null : rolloverRequest.masterNodeTimeout();
            LazyRolloverAction.notifyAllListeners(rolloverTaskContexts, context -> ActiveShardsObserver.waitForActiveShards(this.clusterService, Metadata.DEFAULT_PROJECT_ID, new String[]{rolloverIndexName}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), waitForActiveShardsTimeout, allocationActionMultiListener.delay(((LazyRolloverTask)context.getTask()).listener()).map(isShardsAcknowledged -> new RolloverResponse(sourceIndexName, rolloverIndexName, Map.of(), false, true, true, (boolean)isShardsAcknowledged, false))));
            return rolloverResult.clusterState();
        }
    }

    record LazyRolloverTask(ProjectId projectId, RolloverRequest rolloverRequest, ActionListener<RolloverResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    public static final class TransportLazyRolloverAction
    extends TransportRolloverAction {
        private final MasterServiceTaskQueue<LazyRolloverTask> lazyRolloverTaskQueue;

        @Inject
        public TransportLazyRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, AllocationService allocationService, MetadataDataStreamsService metadataDataStreamsService, DataStreamAutoShardingService dataStreamAutoShardingService, Client client) {
            super(INSTANCE, transportService, clusterService, threadPool, actionFilters, projectResolver, indexNameExpressionResolver, rolloverService, client, allocationService, metadataDataStreamsService, dataStreamAutoShardingService);
            this.lazyRolloverTaskQueue = clusterService.createTaskQueue("lazy-rollover", Priority.NORMAL, new LazyRolloverExecutor(clusterService, allocationService, rolloverService, threadPool));
        }

        @Override
        protected void masterOperation(Task task, RolloverRequest rolloverRequest, ClusterState clusterState, ActionListener<RolloverResponse> listener) throws Exception {
            assert (task instanceof CancellableTask);
            assert (!(rolloverRequest.getConditions().hasConditions() || rolloverRequest.isDryRun() || rolloverRequest.isLazy())) : "The auto rollover action does not expect any other parameters in the request apart from the data stream name";
            ProjectMetadata project = this.projectResolver().getProjectMetadata(clusterState);
            IndexNameExpressionResolver.ResolvedExpression resolvedRolloverTarget = IndexNameExpressionResolver.SelectorResolver.parseExpression(rolloverRequest.getRolloverTarget(), rolloverRequest.indicesOptions());
            boolean isFailureStoreRollover = resolvedRolloverTarget.selector() != null && resolvedRolloverTarget.selector().shouldIncludeFailures();
            DataStream dataStream = project.dataStreams().get(resolvedRolloverTarget.resource());
            if (!LazyRolloverAction.isLazyRolloverNeeded(dataStream, isFailureStoreRollover)) {
                DataStream.DataStreamIndices targetIndices = dataStream.getDataStreamIndices(isFailureStoreRollover);
                listener.onResponse(LazyRolloverAction.noopLazyRolloverResponse(targetIndices));
                return;
            }
            MetadataRolloverService.NameResolution trialRolloverNames = MetadataRolloverService.resolveRolloverNames(project, resolvedRolloverTarget.resource(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), isFailureStoreRollover);
            String trialSourceIndexName = trialRolloverNames.sourceName();
            String trialRolloverIndexName = trialRolloverNames.rolloverName();
            MetadataCreateIndexService.validateIndexName(trialRolloverIndexName, project, clusterState.routingTable(project.id()));
            assert (project.dataStreams().containsKey(resolvedRolloverTarget.resource())) : "Auto-rollover applies only to data streams";
            String source = "lazy_rollover source [" + trialSourceIndexName + "] to target [" + trialRolloverIndexName + "]";
            RolloverRequest newRolloverRequest = new RolloverRequest(resolvedRolloverTarget.combined(), null);
            LazyRolloverTask rolloverTask = new LazyRolloverTask(project.id(), newRolloverRequest, listener);
            this.lazyRolloverTaskQueue.submitTask(source, rolloverTask, rolloverRequest.masterNodeTimeout());
        }
    }
}

