/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class ClusterAllocationExplainRequest
extends MasterNodeRequest<ClusterAllocationExplainRequest> {
    public static final String INDEX_PARAMETER_NAME = "index";
    public static final String SHARD_PARAMETER_NAME = "shard";
    public static final String PRIMARY_PARAMETER_NAME = "primary";
    public static final String CURRENT_NODE_PARAMETER_NAME = "current_node";
    public static final String INCLUDE_YES_DECISIONS_PARAMETER_NAME = "include_yes_decisions";
    public static final String INCLUDE_DISK_INFO_PARAMETER_NAME = "include_disk_info";
    private static final ObjectParser<ClusterAllocationExplainRequest, Void> PARSER = new ObjectParser("cluster/allocation/explain");
    @Nullable
    private String index;
    @Nullable
    private Integer shard;
    @Nullable
    private Boolean primary;
    @Nullable
    private String currentNode;
    private boolean includeYesDecisions = false;
    private boolean includeDiskInfo = false;

    public ClusterAllocationExplainRequest(TimeValue masterNodeTimeout) {
        super(masterNodeTimeout);
        this.index = null;
        this.shard = null;
        this.primary = null;
        this.currentNode = null;
    }

    public ClusterAllocationExplainRequest(StreamInput in) throws IOException {
        super(in);
        this.index = in.readOptionalString();
        this.shard = in.readOptionalVInt();
        this.primary = in.readOptionalBoolean();
        this.currentNode = in.readOptionalString();
        this.includeYesDecisions = in.readBoolean();
        this.includeDiskInfo = in.readBoolean();
    }

    ClusterAllocationExplainRequest(TimeValue masterNodeTimeout, String index, int shard, boolean primary, @Nullable String currentNode) {
        super(masterNodeTimeout);
        this.index = index;
        this.shard = shard;
        this.primary = primary;
        this.currentNode = currentNode;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.index);
        out.writeOptionalVInt(this.shard);
        out.writeOptionalBoolean(this.primary);
        out.writeOptionalString(this.currentNode);
        out.writeBoolean(this.includeYesDecisions);
        out.writeBoolean(this.includeDiskInfo);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!this.useAnyUnassignedShard()) {
            if (this.index == null) {
                validationException = ValidateActions.addValidationError("index must be specified", validationException);
            }
            if (this.shard == null) {
                validationException = ValidateActions.addValidationError("shard must be specified", validationException);
            }
            if (this.primary == null) {
                validationException = ValidateActions.addValidationError("primary must be specified", validationException);
            }
        }
        return validationException;
    }

    public boolean useAnyUnassignedShard() {
        return this.index == null && this.shard == null && this.primary == null && this.currentNode == null;
    }

    public ClusterAllocationExplainRequest setIndex(String index) {
        this.index = index;
        return this;
    }

    @Nullable
    public String getIndex() {
        return this.index;
    }

    public ClusterAllocationExplainRequest setShard(Integer shard) {
        this.shard = shard;
        return this;
    }

    @Nullable
    public Integer getShard() {
        return this.shard;
    }

    public ClusterAllocationExplainRequest setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    public Boolean isPrimary() {
        return this.primary;
    }

    public ClusterAllocationExplainRequest setCurrentNode(String currentNodeId) {
        this.currentNode = currentNodeId;
        return this;
    }

    @Nullable
    public String getCurrentNode() {
        return this.currentNode;
    }

    public void includeYesDecisions(boolean includeYesDecisions) {
        this.includeYesDecisions = includeYesDecisions;
    }

    public boolean includeYesDecisions() {
        return this.includeYesDecisions;
    }

    public void includeDiskInfo(boolean includeDiskInfo) {
        this.includeDiskInfo = includeDiskInfo;
    }

    public boolean includeDiskInfo() {
        return this.includeDiskInfo;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ClusterAllocationExplainRequest[");
        if (this.useAnyUnassignedShard()) {
            sb.append("useAnyUnassignedShard=true");
        } else {
            sb.append(INDEX_PARAMETER_NAME).append("=").append(this.index);
            sb.append(",").append(SHARD_PARAMETER_NAME).append("=").append(this.shard);
            sb.append(",").append(PRIMARY_PARAMETER_NAME).append("?=").append(this.primary);
            if (this.currentNode != null) {
                sb.append(",").append(CURRENT_NODE_PARAMETER_NAME).append("=").append(this.currentNode);
            }
        }
        sb.append(",").append(INCLUDE_YES_DECISIONS_PARAMETER_NAME).append("?=").append(this.includeYesDecisions);
        sb.append(",").append(INCLUDE_DISK_INFO_PARAMETER_NAME).append("?=").append(this.includeDiskInfo);
        return sb.toString();
    }

    public static ClusterAllocationExplainRequest parse(ClusterAllocationExplainRequest request, XContentParser parser) throws IOException {
        return PARSER.parse(parser, request, null);
    }

    static {
        PARSER.declareString(ClusterAllocationExplainRequest::setIndex, new ParseField(INDEX_PARAMETER_NAME, new String[0]));
        PARSER.declareInt(ClusterAllocationExplainRequest::setShard, new ParseField(SHARD_PARAMETER_NAME, new String[0]));
        PARSER.declareBoolean(ClusterAllocationExplainRequest::setPrimary, new ParseField(PRIMARY_PARAMETER_NAME, new String[0]));
        PARSER.declareString(ClusterAllocationExplainRequest::setCurrentNode, new ParseField(CURRENT_NODE_PARAMETER_NAME, new String[0]));
    }
}

