/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.resolver;

import co.elastic.logstash.filters.elasticintegration.resolver.CacheReloader;
import co.elastic.logstash.filters.elasticintegration.resolver.CacheableResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.ResolverCache;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleResolverCache<K, V>
implements ResolverCache<K, V> {
    private final LongSupplier nanoTimeSupplier;
    private final Configuration configuration;
    private final String type;
    private static final Logger LOGGER = LogManager.getLogger(SimpleResolverCache.class);
    private final ConcurrentMap<K, CacheResult> persistentCache = new ConcurrentHashMap<K, CacheResult>();
    private final SimpleMultiLock<K> loadLock = new SimpleMultiLock();

    public SimpleResolverCache(String type) {
        this(type, Configuration.PERMANENT);
    }

    public SimpleResolverCache(String type, Configuration configuration) {
        this(System::nanoTime, type, configuration);
    }

    SimpleResolverCache(LongSupplier nanoTimeSupplier, String type, Configuration configuration) {
        this.nanoTimeSupplier = nanoTimeSupplier;
        this.type = type;
        this.configuration = configuration;
    }

    @Override
    public Optional<V> resolve(K resolveKey, CacheableResolver.Ephemeral<K, V> cacheMissResolver, Consumer<Exception> exceptionHandler) {
        CacheResult cacheResult = this.pruningFastResolveFromCache(resolveKey);
        if (Objects.nonNull(cacheResult)) {
            LOGGER.trace(() -> String.format("cached-hit(%s:fast){ %s -> %s }", this.type, resolveKey, cacheResult.getCachedValue()));
            return Optional.ofNullable(cacheResult.getCachedValue());
        }
        return Optional.ofNullable(this.persistentCache.compute(resolveKey, (rKey, existing) -> {
            if (Objects.nonNull(existing) && !existing.isExpired()) {
                LOGGER.trace(() -> String.format("cached-hit(%s:slow){ %s -> %s }", this.type, resolveKey, existing.getCachedValue()));
                return existing;
            }
            return this.loadLock.withLock(resolveKey, () -> {
                try {
                    CacheResult retrieved = this.doGet(rKey, cacheMissResolver, exceptionHandler);
                    LOGGER.trace(() -> String.format("uncached-load(%s){ %s -> %s }", this.type, resolveKey, retrieved.getCachedValue()));
                    return retrieved.isHit() || !retrieved.isExpired() ? retrieved : null;
                }
                catch (Exception e) {
                    LOGGER.debug(() -> String.format("uncached-load-exception(%s){ %s !> %s }", this.type, resolveKey), (Throwable)e);
                    throw e;
                }
            });
        })).map(CacheResult::getCachedValue);
    }

    @Override
    public CacheReloader getReloader(CacheableResolver.Ephemeral<K, V> innerResolver) {
        return new Reloader(innerResolver);
    }

    @Override
    public void flush() {
        this.keys().forEach(this::pruningFastResolveFromCache);
    }

    @Override
    public void clear() {
        this.persistentCache.clear();
    }

    @Override
    public Set<K> keys() {
        return this.persistentCache.keySet();
    }

    @Override
    public void reload(K resolveKey, CacheableResolver.Ephemeral<K, V> resolver) {
        CacheResult initialCacheResult = this.pruningFastResolveFromCache(resolveKey);
        if (Objects.isNull(initialCacheResult)) {
            LOGGER.warn(() -> String.format("reload-gone(%s) { %s } the entry disappeared from the cache", this.type, resolveKey));
        }
        Exception[] exceptionHolder = new Exception[1];
        Optional resolveResult = this.loadLock.withLock(resolveKey, () -> resolver.resolve(resolveKey, e -> {
            exceptionHolder[0] = e;
        }));
        Exception resolveException = exceptionHolder[0];
        if (Objects.nonNull(resolveException)) {
            LOGGER.warn(() -> {
                if (Objects.nonNull(initialCacheResult)) {
                    String ttlRemainingDesc = SimpleResolverCache.humanReadableDuration(initialCacheResult.getRemainingNanos());
                    String cachedResultDesc = initialCacheResult.isHit() ? "non-empty value" : "empty value";
                    return String.format("reload-failure(%s) { %s } the existing cached %s will continue to be available until it expires in ~%s", this.type, resolveKey, cachedResultDesc, ttlRemainingDesc);
                }
                return String.format("reload-failure(%s) { %s } there is no existing cached value", this.type, resolveKey);
            }, (Throwable)resolveException);
            return;
        }
        this.persistentCache.compute(resolveKey, (k, currentCacheResult) -> {
            if (Objects.nonNull(currentCacheResult) && currentCacheResult.isHit() && resolveResult.isPresent() && Objects.equals(resolveResult.get(), currentCacheResult.getCachedValue())) {
                LOGGER.debug(() -> String.format("reload-unchanged(%s) { %s }", this.type, resolveKey));
                return new CacheHit(currentCacheResult.getCachedValue());
            }
            if (resolveResult.isPresent()) {
                LOGGER.info(() -> String.format("reload-modified(%s) { %s }", this.type, resolveKey));
                return new CacheHit(resolveResult.get());
            }
            if (Objects.nonNull(currentCacheResult) && currentCacheResult.isHit()) {
                LOGGER.info(() -> String.format("reload-removed(%s) { %s }", this.type, resolveKey));
                return new CacheMiss();
            }
            return currentCacheResult;
        });
    }

    private CacheResult pruningFastResolveFromCache(K resolveKey) {
        CacheResult cacheResult = (CacheResult)this.persistentCache.get(resolveKey);
        if (Objects.nonNull(cacheResult) && cacheResult.isExpired()) {
            if (this.persistentCache.remove(resolveKey, cacheResult)) {
                LOGGER.debug(() -> String.format("expired(%s) { %s }", this.type, resolveKey));
            }
            cacheResult = null;
        }
        return cacheResult;
    }

    private CacheResult doGet(K resolveKey, CacheableResolver.Ephemeral<K, V> innerResolver, Consumer<Exception> exceptionHandler) {
        LOGGER.debug(() -> String.format("loading %s: `%s`", this.type, resolveKey));
        return innerResolver.resolve(resolveKey, exceptionHandler).map(this.cacheHit(resolveKey)).orElseGet(this.cacheMiss(resolveKey));
    }

    private Function<V, CacheResult> cacheHit(K resolveKey) {
        return resolveResult -> {
            LOGGER.debug(() -> String.format("loaded %s: `%s`", this.type, resolveKey));
            return new CacheHit(resolveResult);
        };
    }

    private Supplier<CacheResult> cacheMiss(K resolveKey) {
        return () -> {
            LOGGER.debug(() -> String.format("failed to load %s: `%s`", this.type, resolveKey));
            return new CacheMiss();
        };
    }

    static String humanReadableDuration(long nanos) {
        return Duration.ofNanos(nanos).truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("[^0-9YDHMS]", "").toLowerCase();
    }

    public record Configuration(long maxHitAgeNanos, long maxMissAgeNanos) {
        public static Configuration PERMANENT = new Configuration(Long.MAX_VALUE, 0L);

        public Configuration(Duration maxHitAge, Duration maxMissAge) {
            this(maxHitAge.toNanos(), maxMissAge.toNanos());
        }
    }

    public static class SimpleMultiLock<T> {
        private final ConcurrentMap<T, Object> lockMap = new ConcurrentHashMap<T, Object>();

        public <X> X withLock(T resolveKey, Supplier<X> lockable) {
            Object result = this.lockMap.compute(resolveKey, (k, cr) -> lockable.get());
            if (Objects.nonNull(result)) {
                this.lockMap.remove(resolveKey, result);
            }
            return (X)result;
        }

        public void withLock(T resolveKey, Runnable lockable) {
            this.withLock(resolveKey, () -> {
                lockable.run();
                return null;
            });
        }
    }

    abstract class CacheResult {
        private final long nanoTimestamp;

        public CacheResult() {
            this.nanoTimestamp = SimpleResolverCache.this.nanoTimeSupplier.getAsLong();
        }

        public abstract boolean isHit();

        public long getAgeNanos() {
            return SimpleResolverCache.this.nanoTimeSupplier.getAsLong() - this.nanoTimestamp;
        }

        abstract V getCachedValue();

        abstract long getRemainingNanos();

        boolean isExpired() {
            return this.getRemainingNanos() <= 0L;
        }
    }

    class Reloader
    implements CacheReloader {
        private final CacheableResolver.Ephemeral<K, V> innerResolver;

        public Reloader(CacheableResolver.Ephemeral<K, V> innerResolver) {
            this.innerResolver = innerResolver;
        }

        @Override
        public String type() {
            return SimpleResolverCache.this.type;
        }

        @Override
        public void reloadOnce() {
            SimpleResolverCache.this.persistentCache.keySet().forEach(this::reloadSingleEntry);
        }

        private void reloadSingleEntry(K resolveKey) {
            SimpleResolverCache.this.reload(resolveKey, this.innerResolver);
        }
    }

    private class CacheMiss
    extends CacheResult {
        private CacheMiss() {
        }

        @Override
        V getCachedValue() {
            return null;
        }

        @Override
        public boolean isHit() {
            return false;
        }

        @Override
        long getRemainingNanos() {
            return Math.subtractExact(SimpleResolverCache.this.configuration.maxMissAgeNanos, this.getAgeNanos());
        }
    }

    private class CacheHit
    extends CacheResult {
        private final V value;

        public CacheHit(V value) {
            this.value = value;
        }

        @Override
        V getCachedValue() {
            return this.value;
        }

        @Override
        public boolean isHit() {
            return true;
        }

        @Override
        long getRemainingNanos() {
            return Math.subtractExact(SimpleResolverCache.this.configuration.maxHitAgeNanos, this.getAgeNanos());
        }
    }
}

