/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.ingest;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.logstashbridge.core.IOUtilsBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorFactoryBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorParametersBridge;
import org.elasticsearch.logstashbridge.plugins.IngestPluginBridge;

public class SingleProcessorIngestPlugin
implements IngestPluginBridge,
Closeable {
    private final String type;
    private final ProcessorFactoryBridge processorFactory;

    public static Supplier<IngestPluginBridge> of(String type, Supplier<ProcessorFactoryBridge> factorySupplier) {
        return () -> new SingleProcessorIngestPlugin(type, (ProcessorFactoryBridge)factorySupplier.get());
    }

    public SingleProcessorIngestPlugin(String type, ProcessorFactoryBridge processorFactory) {
        this.type = type;
        this.processorFactory = processorFactory;
    }

    @Override
    public Map<String, ProcessorFactoryBridge> getProcessors(ProcessorParametersBridge parameters) {
        return Map.of(this.type, this.processorFactory);
    }

    @Override
    public void close() throws IOException {
        if (this.processorFactory instanceof Closeable) {
            IOUtilsBridge.closeWhileHandlingException((Closeable)((Object)this.processorFactory));
        }
    }
}

