/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.ingest;

import co.elastic.logstash.filters.elasticintegration.IngestPipeline;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineResolver;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.logstashbridge.common.ProjectIdBridge;
import org.elasticsearch.logstashbridge.ingest.AbstractExternalProcessorBridge;
import org.elasticsearch.logstashbridge.ingest.AbstractExternalProcessorFactoryBridge;
import org.elasticsearch.logstashbridge.ingest.ConfigurationUtilsBridge;
import org.elasticsearch.logstashbridge.ingest.IngestDocumentBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorFactoryBridge;
import org.elasticsearch.logstashbridge.script.ScriptServiceBridge;
import org.elasticsearch.logstashbridge.script.TemplateScriptFactoryBridge;

public class PipelineProcessor
extends AbstractExternalProcessorBridge {
    public static final String TYPE = "pipeline";
    private final String tag;
    private final String description;
    private final String pipelineName;
    private final TemplateScriptFactoryBridge pipelineTemplate;
    private final IngestPipelineResolver pipelineProvider;
    private final boolean ignoreMissingPipeline;

    private PipelineProcessor(String tag, String description, TemplateScriptFactoryBridge pipelineTemplate, String pipelineName, boolean ignoreMissingPipeline, IngestPipelineResolver pipelineProvider) {
        this.tag = tag;
        this.description = description;
        this.pipelineTemplate = pipelineTemplate;
        this.pipelineName = pipelineName;
        this.pipelineProvider = pipelineProvider;
        this.ignoreMissingPipeline = ignoreMissingPipeline;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void execute(IngestDocumentBridge ingestDocument, BiConsumer<IngestDocumentBridge, Exception> handler) {
        String pipelineName = ingestDocument.renderTemplate(this.pipelineTemplate);
        IngestPipeline pipeline = this.pipelineProvider.resolve(pipelineName).orElse(null);
        if (pipeline != null) {
            pipeline.execute(ingestDocument, handler);
        } else if (this.ignoreMissingPipeline) {
            handler.accept(ingestDocument, null);
        } else {
            handler.accept(null, new IllegalStateException("Pipeline processor configured for non-existent pipeline [" + pipelineName + "]"));
        }
    }

    public static class Factory
    extends AbstractExternalProcessorFactoryBridge {
        private final IngestPipelineResolver pipelineProvider;
        private final ScriptServiceBridge scriptService;

        public Factory(IngestPipelineResolver pipelineProvider, ScriptServiceBridge scriptService) {
            this.pipelineProvider = pipelineProvider;
            this.scriptService = scriptService;
        }

        @Override
        public ProcessorBridge create(Map<String, ProcessorFactoryBridge> registry, String processorTag, String description, Map<String, Object> config, ProjectIdBridge projectIdBridge) throws Exception {
            String pipeline = ConfigurationUtilsBridge.readStringProperty(PipelineProcessor.TYPE, processorTag, config, "name");
            TemplateScriptFactoryBridge pipelineTemplate = ConfigurationUtilsBridge.compileTemplate(PipelineProcessor.TYPE, processorTag, "name", pipeline, this.scriptService);
            boolean ignoreMissingPipeline = ConfigurationUtilsBridge.readBooleanProperty(PipelineProcessor.TYPE, processorTag, config, "ignore_missing_pipeline", false);
            return new PipelineProcessor(processorTag, description, pipelineTemplate, pipeline, ignoreMissingPipeline, this.pipelineProvider);
        }
    }
}

