/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.filters.elasticintegration.IngestPipeline;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.ingest.PipelineProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.logstashbridge.ingest.PipelineBridge;
import org.elasticsearch.logstashbridge.ingest.PipelineConfigurationBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorFactoryBridge;
import org.elasticsearch.logstashbridge.script.ScriptServiceBridge;

public class IngestPipelineFactory {
    private final ScriptServiceBridge scriptService;
    private final Map<String, ProcessorFactoryBridge> processorFactories;
    private static final Logger LOGGER = LogManager.getLogger(IngestPipelineFactory.class);

    public IngestPipelineFactory(ScriptServiceBridge scriptService) {
        this(scriptService, Map.of());
    }

    private IngestPipelineFactory(ScriptServiceBridge scriptService, Map<String, ProcessorFactoryBridge> processorFactories) {
        this.scriptService = scriptService;
        this.processorFactories = Map.copyOf(processorFactories);
    }

    public IngestPipelineFactory withProcessors(Map<String, ProcessorFactoryBridge> processorFactories) {
        HashMap<String, ProcessorFactoryBridge> intermediate = new HashMap<String, ProcessorFactoryBridge>(this.processorFactories);
        intermediate.putAll(processorFactories);
        return new IngestPipelineFactory(this.scriptService, intermediate);
    }

    public Optional<IngestPipeline> create(PipelineConfigurationBridge pipelineConfiguration) {
        try {
            PipelineBridge pipeline = PipelineBridge.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfig(false), this.processorFactories, this.scriptService);
            IngestPipeline ingestPipeline = new IngestPipeline(pipelineConfiguration, pipeline);
            LOGGER.debug(() -> String.format("successfully created ingest pipeline `%s` from pipeline configuration", pipelineConfiguration.getId()));
            return Optional.of(ingestPipeline);
        }
        catch (Exception e) {
            LOGGER.error(() -> String.format("failed to create ingest pipeline `%s` from pipeline configuration", pipelineConfiguration.getId()), (Throwable)e);
            return Optional.empty();
        }
    }

    public IngestPipelineFactory withIngestPipelineResolver(IngestPipelineResolver ingestPipelineResolver) {
        HashMap<String, ProcessorFactoryBridge> modifiedProcessorFactories = new HashMap<String, ProcessorFactoryBridge>(this.processorFactories);
        modifiedProcessorFactories.put("pipeline", new PipelineProcessor.Factory(ingestPipelineResolver, this.scriptService));
        return new IngestPipelineFactory(this.scriptService, modifiedProcessorFactories);
    }
}

