/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.EventFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.logstashbridge.ingest.IngestDocumentBridge;
import org.elasticsearch.logstashbridge.script.MetadataBridge;
import org.logstash.Javafier;
import org.logstash.Timestamp;
import org.logstash.plugins.BasicEventFactory;

public class IngestDuplexMarshaller {
    private final EventFactory eventFactory;
    private final Logger logger;
    private static final Logger DEFAULT_LOGGER = LogManager.getLogger(IngestDuplexMarshaller.class);
    static final String LOGSTASH_VERSION_FALLBACK = "_@version";
    static final String LOGSTASH_TIMESTAMP_FALLBACK = "_@timestamp";
    static final String LOGSTASH_METADATA_FALLBACK = "_@metadata";
    static final String LOGSTASH_TAGS_FALLBACK = "_tags";
    static final String INGEST_METADATA_TIMESTAMP_FIELD = "timestamp";
    static final String ECS_EVENT_CREATED_FIELD = "event.created";
    static final String VERSION_ONE = "1";
    static final String INGEST_DOCUMENT = "_ingest_document";
    static final String LOGSTASH_METADATA_INGEST_DOCUMENT_METADATA = "[@metadata][_ingest_document]";
    private static final IngestDuplexMarshaller DEFAULT_INSTANCE = new IngestDuplexMarshaller(DEFAULT_LOGGER);
    private static final ZoneId UTC = ZoneId.of("UTC");

    private IngestDuplexMarshaller(EventFactory eventFactory, Logger logger) {
        this.eventFactory = eventFactory;
        this.logger = logger;
    }

    IngestDuplexMarshaller(Logger logger) {
        this(BasicEventFactory.INSTANCE, logger);
    }

    public static IngestDuplexMarshaller defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public IngestDocumentBridge toIngestDocument(Event event) {
        HashMap<String, Object> sourceAndMetadata = new HashMap<String, Object>(this.externalize(event.getData()));
        Map eventMetadata = event.getMetadata();
        if (!eventMetadata.isEmpty()) {
            sourceAndMetadata.put("@metadata", this.externalize(eventMetadata));
        }
        this.sanitizeIngestDocumentRequiredMetadataVersion(sourceAndMetadata, event);
        Timestamp eventTimestamp = this.safeTimestampFrom(event.getField("@timestamp"));
        Map<String, Object> ingestMetadata = Map.of(INGEST_METADATA_TIMESTAMP_FIELD, Objects.requireNonNullElseGet(eventTimestamp, Timestamp::now).toString());
        return IngestDocumentBridge.create(sourceAndMetadata, ingestMetadata);
    }

    private Object externalize(@Nullable Object internalObject) {
        if (Objects.isNull(internalObject)) {
            return null;
        }
        if (internalObject instanceof Map) {
            Map internalMap = (Map)internalObject;
            return this.externalize(internalMap);
        }
        if (internalObject instanceof List) {
            List internalList = (List)internalObject;
            return this.externalize(internalList);
        }
        if (internalObject instanceof Set) {
            Set internalSet = (Set)internalObject;
            return this.externalize(internalSet);
        }
        Object javafiedInternalObject = Javafier.deep((Object)internalObject);
        if (javafiedInternalObject instanceof Timestamp) {
            Timestamp internalTimestamp = (Timestamp)javafiedInternalObject;
            return internalTimestamp.toString();
        }
        return javafiedInternalObject;
    }

    private Map<String, Object> externalize(@Nonnull Map<?, ?> internalMap) {
        HashMap<String, Object> externalizedMap = new HashMap<String, Object>();
        internalMap.forEach((k, v) -> {
            String externalizedKey = Objects.toString(k);
            Object externalizedValue = this.externalize(v);
            externalizedMap.put(externalizedKey, externalizedValue);
        });
        return externalizedMap;
    }

    private List<Object> externalize(@Nonnull List<?> internalList) {
        ArrayList<Object> externalizedList = new ArrayList<Object>();
        internalList.forEach(v -> {
            Object externalizedValue = this.externalize(v);
            externalizedList.add(externalizedValue);
        });
        return externalizedList;
    }

    private Set<Object> externalize(@Nonnull Set<?> internalSet) {
        HashSet<Object> externalizedSet = new HashSet<Object>();
        internalSet.forEach(v -> {
            Object externalizedValue = this.externalize(v);
            externalizedSet.add(externalizedValue);
        });
        return externalizedSet;
    }

    private void sanitizeIngestDocumentRequiredMetadataVersion(Map<String, Object> sourceAndMetadata, Event event) {
        Long sourceVersion = this.safeLongFrom(sourceAndMetadata.remove(IngestDocumentBridge.Constants.METADATA_VERSION_FIELD_NAME));
        if (Objects.isNull(sourceVersion)) {
            sourceVersion = this.safeLongFrom(event.getField("@version"));
        }
        sourceAndMetadata.put(IngestDocumentBridge.Constants.METADATA_VERSION_FIELD_NAME, Objects.requireNonNullElse(sourceVersion, 1L));
    }

    private Long safeLongFrom(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        Object jVersionField = Javafier.deep((Object)object);
        if (jVersionField instanceof String) {
            try {
                return Long.parseLong((String)jVersionField);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (jVersionField instanceof Long) {
            return (Long)jVersionField;
        }
        if (jVersionField instanceof Integer) {
            return ((Integer)jVersionField).longValue();
        }
        return null;
    }

    public Event toLogstashEvent(IngestDocumentBridge ingestDocument) {
        Map<String, Object> eventMap = this.internalize(ingestDocument.getSource());
        this.sanitizeEventRequiredTimestamp(eventMap, ingestDocument);
        this.sanitizeEventRequiredVersion(eventMap, ingestDocument);
        this.sanitizeEventRequiredMetadata(eventMap);
        this.sanitizeEventOptionalTags(eventMap);
        Event event = this.eventFactory.newEvent(eventMap);
        event.setField(LOGSTASH_METADATA_INGEST_DOCUMENT_METADATA, this.normalizeIngestDocumentMetadata(ingestDocument));
        return event;
    }

    private Object internalize(@Nullable Object externalObject) {
        if (Objects.isNull(externalObject)) {
            return null;
        }
        if (externalObject instanceof Map) {
            Map externalMap = (Map)externalObject;
            return this.internalize(externalMap);
        }
        if (externalObject instanceof List) {
            List externalList = (List)externalObject;
            return this.internalize(externalList);
        }
        if (externalObject instanceof Set) {
            Set externalSet = (Set)externalObject;
            return this.internalize(externalSet);
        }
        if (externalObject instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)externalObject;
            return new Timestamp(zonedDateTime.toInstant());
        }
        if (externalObject.getClass().isArray()) {
            return this.internalize(Arrays.asList((Object[])externalObject));
        }
        return Javafier.deep((Object)externalObject);
    }

    private Map<String, Object> internalize(@Nonnull Map<?, ?> externalMap) {
        HashMap<String, Object> internalMap = new HashMap<String, Object>();
        externalMap.forEach((k, v) -> {
            String internalizedKey = Objects.toString(k);
            Object internalizedValue = this.internalize(v);
            internalMap.put(internalizedKey, internalizedValue);
        });
        return internalMap;
    }

    private List<Object> internalize(@Nonnull Collection<?> externalCollection) {
        ArrayList<Object> internalList = new ArrayList<Object>();
        externalCollection.forEach(v -> {
            Object internalizedValue = this.internalize(v);
            internalList.add(internalizedValue);
        });
        return internalList;
    }

    private Map<String, Object> normalizeIngestDocumentMetadata(IngestDocumentBridge ingestDocument) {
        HashMap<String, Object> collectedMetadata = new HashMap<String, Object>();
        MetadataBridge metadata = ingestDocument.getMetadata();
        collectedMetadata.put("index", metadata.getIndex());
        collectedMetadata.put("id", metadata.getId());
        collectedMetadata.put("version", metadata.getVersion());
        collectedMetadata.put("version_type", metadata.getVersionType());
        collectedMetadata.put("routing", metadata.getRouting());
        collectedMetadata.put(INGEST_METADATA_TIMESTAMP_FIELD, ingestDocument.getIngestMetadata().get(INGEST_METADATA_TIMESTAMP_FIELD));
        collectedMetadata.values().removeIf(Objects::isNull);
        return collectedMetadata;
    }

    private void sanitizeEventRequiredVersion(Map<String, Object> eventMap, IngestDocumentBridge ingestDocument) {
        Object sourceVersion = eventMap.remove("@version");
        String safeVersion = null;
        if (Objects.nonNull(sourceVersion)) {
            String stringVersion = sourceVersion.toString();
            if (stringVersion.matches("\\d+")) {
                safeVersion = stringVersion;
            } else {
                eventMap.put(LOGSTASH_VERSION_FALLBACK, sourceVersion);
            }
        }
        if (Objects.isNull(safeVersion)) {
            long version = ingestDocument.getMetadata().getVersion();
            safeVersion = version == 1L ? VERSION_ONE : Long.toString(version);
        }
        eventMap.put("@version", safeVersion);
    }

    private void sanitizeEventRequiredTimestamp(Map<String, Object> eventMap, IngestDocumentBridge ingestDocument) {
        Object sourceTimestamp = eventMap.remove("@timestamp");
        Timestamp safeTimestamp = this.safeTimestampFrom(sourceTimestamp);
        if (Objects.isNull(safeTimestamp)) {
            if (Objects.nonNull(sourceTimestamp)) {
                eventMap.put(LOGSTASH_TIMESTAMP_FALLBACK, sourceTimestamp);
            }
            if (Objects.isNull(safeTimestamp = this.safeTimestampFrom(ingestDocument.getFieldValue(ECS_EVENT_CREATED_FIELD, Object.class, true))) && Objects.isNull(safeTimestamp = this.safeTimestampFrom(ingestDocument.getIngestMetadata().get(INGEST_METADATA_TIMESTAMP_FIELD)))) {
                safeTimestamp = this.safeTimestampFrom(ingestDocument.getMetadata().getNow());
            }
        }
        eventMap.put("@timestamp", Objects.requireNonNullElseGet(safeTimestamp, Timestamp::new));
    }

    private Timestamp safeTimestampFrom(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        try {
            if (object instanceof String) {
                String string = (String)object;
                return new Timestamp(string);
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                return timestamp;
            }
            if (object instanceof Instant) {
                Instant instant = (Instant)object;
                return new Timestamp(instant);
            }
            if (object instanceof ZonedDateTime) {
                ZonedDateTime zonedDateTime = (ZonedDateTime)object;
                return new Timestamp(zonedDateTime.toInstant());
            }
            Timestamp bruteForceTimestamp = new Timestamp(object.toString());
            this.logger.debug(() -> String.format("Successful brute-force parsing of timestamp-like object `%s` (%s) into `%s`", object, object.getClass(), bruteForceTimestamp));
            return bruteForceTimestamp;
        }
        catch (Exception e) {
            this.logger.trace(() -> String.format("failed to extract a Timestamp from `%s`", object), (Throwable)e);
            return null;
        }
    }

    private void sanitizeEventRequiredMetadata(Map<String, Object> eventMap) {
        Object sourceMetadata = eventMap.remove("@metadata");
        Map<String, Object> safeMetadata = null;
        if (Objects.nonNull(sourceMetadata)) {
            if (sourceMetadata instanceof Map) {
                Map sourceMetadataMap = (Map)sourceMetadata;
                try {
                    safeMetadata = IngestDuplexMarshaller.preCheckedMap(sourceMetadataMap, String.class, Object.class);
                }
                catch (ClassCastException cce) {
                    this.logger.trace(() -> String.format("metadata could not be cast into safe shape: %s", sourceMetadata), (Throwable)cce);
                }
            } else {
                this.logger.trace(() -> String.format("metadata could not be coerced into safe shape: %s (%s)", sourceMetadata, sourceMetadata.getClass()));
            }
            if (Objects.isNull(safeMetadata)) {
                eventMap.put(LOGSTASH_METADATA_FALLBACK, sourceMetadata);
            }
        }
        eventMap.put("@metadata", Objects.requireNonNullElseGet(safeMetadata, HashMap::new));
    }

    private void sanitizeEventOptionalTags(Map<String, Object> eventMap) {
        List<String> sourceTags = eventMap.remove("tags");
        if (Objects.nonNull(sourceTags)) {
            List<String> coercibleTags = null;
            if (sourceTags instanceof String) {
                coercibleTags = sourceTags;
            } else if (sourceTags instanceof List) {
                List sourceTagsList = sourceTags;
                try {
                    coercibleTags = IngestDuplexMarshaller.preCheckedList(sourceTagsList, String.class);
                }
                catch (ClassCastException cce) {
                    this.logger.trace(() -> String.format("tags field could not be coerced into safe shape: %s", sourceTags), (Throwable)cce);
                }
            } else {
                this.logger.trace(() -> String.format("tags field could not be coerced into safe shape: %s (%s)", sourceTags, sourceTags.getClass()));
            }
            if (Objects.nonNull(coercibleTags)) {
                eventMap.put("tags", coercibleTags);
            } else {
                eventMap.put(LOGSTASH_TAGS_FALLBACK, sourceTags);
            }
        }
    }

    static <K, V> Map<K, V> preCheckedMap(Map<?, ?> map, Class<K> kClass, Class<V> vClass) throws ClassCastException {
        Map<?, ?> checkedMap = Collections.checkedMap(map, kClass, vClass);
        checkedMap.forEach((k, v) -> {
            if (Objects.nonNull(k)) {
                kClass.cast(k);
            }
            if (Objects.nonNull(v)) {
                vClass.cast(v);
            }
        });
        return checkedMap;
    }

    static <V> List<V> preCheckedList(List<?> list, Class<V> vClass) throws ClassCastException {
        List<?> checkedList = Collections.checkedList(list, vClass);
        checkedList.forEach(v -> {
            if (Objects.nonNull(v)) {
                vClass.cast(v);
            }
        });
        return checkedList;
    }
}

