/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.http;

import co.elastic.clients.transport.http.TransportHttpClient;
import co.elastic.clients.util.BinaryData;
import co.elastic.clients.util.ByteArrayBinaryData;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public class RepeatableBodyResponse
implements TransportHttpClient.Response {
    private final TransportHttpClient.Response response;
    private final BinaryData body;

    public static TransportHttpClient.Response of(TransportHttpClient.Response response) throws IOException {
        BinaryData body = response.body();
        if (body == null || body.isRepeatable()) {
            return response;
        }
        return new RepeatableBodyResponse(response);
    }

    public RepeatableBodyResponse(TransportHttpClient.Response response) throws IOException {
        this.response = response;
        this.body = new ByteArrayBinaryData(response.body());
    }

    @Override
    public TransportHttpClient.Node node() {
        return this.response.node();
    }

    @Override
    public int statusCode() {
        return this.response.statusCode();
    }

    @Override
    @Nullable
    public String header(String name) {
        return this.response.header(name);
    }

    @Override
    public List<String> headers(String name) {
        return this.response.headers(name);
    }

    @Override
    @Nullable
    public BinaryData body() throws IOException {
        return this.body;
    }

    @Override
    @Nullable
    public Object originalResponse() {
        return this.response.originalResponse();
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }
}

