/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.SyncJobErrorResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class SyncJobErrorRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorSyncJobId;
    private final String error;
    public static final JsonpDeserializer<SyncJobErrorRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SyncJobErrorRequest::setupSyncJobErrorRequestDeserializer);
    public static final Endpoint<SyncJobErrorRequest, SyncJobErrorResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SyncJobErrorRequest, SyncJobErrorResponse>("es/connector.sync_job_error", request -> "PUT", request -> {
        boolean _connectorSyncJobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/_sync_job");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorSyncJobId, buf);
            buf.append("/_error");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorSyncJobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorSyncJobId", request.connectorSyncJobId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SyncJobErrorResponse._DESERIALIZER);

    private SyncJobErrorRequest(Builder builder) {
        this.connectorSyncJobId = ApiTypeHelper.requireNonNull(builder.connectorSyncJobId, this, "connectorSyncJobId");
        this.error = ApiTypeHelper.requireNonNull(builder.error, this, "error");
    }

    public static SyncJobErrorRequest of(Function<Builder, ObjectBuilder<SyncJobErrorRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorSyncJobId() {
        return this.connectorSyncJobId;
    }

    public final String error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error");
        generator.write(this.error);
    }

    protected static void setupSyncJobErrorRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SyncJobErrorRequest> {
        private String connectorSyncJobId;
        private String error;

        public final Builder connectorSyncJobId(String value) {
            this.connectorSyncJobId = value;
            return this;
        }

        public final Builder error(String value) {
            this.error = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SyncJobErrorRequest build() {
            this._checkSingleUse();
            return new SyncJobErrorRequest(this);
        }
    }
}

