/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.net.InetAddress;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;

public class DtlsAddress
extends UdpAddress {
    static final long serialVersionUID = 0L;
    private static final LogAdapter logger = LogFactory.getLogger(DtlsAddress.class);

    public DtlsAddress() {
    }

    public DtlsAddress(UdpAddress udpAddress) {
        super(udpAddress.getInetAddress(), udpAddress.getPort());
    }

    public DtlsAddress(InetAddress inetAddress, int port) {
        super(inetAddress, port);
    }

    public DtlsAddress(int port) {
        super(port);
    }

    public DtlsAddress(String address) {
        if (!this.parseAddress(address)) {
            throw new IllegalArgumentException(address);
        }
    }

    public static Address parse(String address) {
        try {
            DtlsAddress a = new DtlsAddress();
            if (a.parseAddress(address)) {
                return a;
            }
        }
        catch (Exception ex) {
            logger.error(ex);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DtlsAddress && super.equals(o);
    }

    @Override
    public boolean isTransportCompatible(Class<?> other) {
        return this.getClass().isAssignableFrom(other);
    }
}

