/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.IOException;
import java.util.Arrays;
import json.ext.AbstractByteListDirectOutputStream;
import org.jcodings.Encoding;
import org.jruby.util.ByteList;

public class ByteListDirectOutputStream
extends AbstractByteListDirectOutputStream {
    private byte[] buffer;
    private int length;

    ByteListDirectOutputStream(int n) {
        this.buffer = new byte[n];
    }

    public ByteList toByteListDirect(Encoding encoding) {
        return new ByteList(this.buffer, 0, this.length, encoding, false);
    }

    public void write(int n) throws IOException {
        int n2 = this.length;
        int n3 = n2 + 1;
        byte[] byArray = ByteListDirectOutputStream.ensureBuffer(this, n3);
        byArray[n2] = (byte)n;
        this.length = n3;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.length;
        int n4 = n3 + n2;
        byte[] byArray2 = ByteListDirectOutputStream.ensureBuffer(this, n4);
        System.arraycopy(byArray, n, byArray2, n3, n2);
        this.length = n4;
    }

    public void write(byte[] byArray) throws IOException {
        int n = this.length;
        int n2 = byArray.length;
        int n3 = n + n2;
        byte[] byArray2 = ByteListDirectOutputStream.ensureBuffer(this, n3);
        System.arraycopy(byArray, 0, byArray2, n, n2);
        this.length = n3;
    }

    private static byte[] ensureBuffer(ByteListDirectOutputStream byteListDirectOutputStream, int n) {
        byte[] byArray = byteListDirectOutputStream.buffer;
        int n2 = byArray.length;
        int n3 = n - n2;
        if (n3 > 0) {
            byArray = byteListDirectOutputStream.buffer = ByteListDirectOutputStream.grow(byArray, n2, n3);
        }
        return byArray;
    }

    private static byte[] grow(byte[] byArray, int n, int n2) {
        int n3 = n + Math.max(n, n2);
        if (n3 < 0 && (n3 = n + n2) < 0) {
            throw new ArrayIndexOutOfBoundsException("cannot allocate array of size " + n + "+" + n2);
        }
        return Arrays.copyOf(byArray, n3);
    }
}

