/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.msgpack.jruby.Decoder;
import org.msgpack.jruby.ExtensionRegistry;

@JRubyClass(name={"MessagePack::Unpacker"})
public class Unpacker
extends RubyObject {
    private static final long serialVersionUID = 8451264671199362492L;
    private final transient ExtensionRegistry registry;
    private transient IRubyObject stream;
    private transient IRubyObject data;
    private transient Decoder decoder;
    private final RubyClass underflowErrorClass;
    private boolean symbolizeKeys;
    private boolean freeze;
    private boolean allowUnknownExt;

    public Unpacker(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, new ExtensionRegistry());
    }

    public Unpacker(Ruby ruby, RubyClass rubyClass, ExtensionRegistry extensionRegistry) {
        super(ruby, rubyClass);
        this.registry = extensionRegistry;
        this.underflowErrorClass = ruby.getModule("MessagePack").getClass("UnderflowError");
    }

    @JRubyMethod(name={"initialize"}, optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.runtime;
        this.symbolizeKeys = false;
        this.allowUnknownExt = false;
        this.freeze = false;
        IRubyObject iRubyObject = null;
        RubyHash rubyHash = null;
        if (iRubyObjectArray.length >= 1) {
            iRubyObject = iRubyObjectArray[0];
        }
        if (iRubyObjectArray.length >= 2 && iRubyObjectArray[1] != ruby.getNil()) {
            rubyHash = (RubyHash)iRubyObjectArray[1];
        }
        if (rubyHash == null && iRubyObject != null && iRubyObject instanceof RubyHash) {
            rubyHash = (RubyHash)iRubyObject;
            iRubyObject = null;
        }
        if (rubyHash != null) {
            IRubyObject iRubyObject2;
            IRubyObject iRubyObject3;
            IRubyObject iRubyObject4 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("symbolize_keys"));
            if (iRubyObject4 != null) {
                this.symbolizeKeys = iRubyObject4.isTrue();
            }
            if ((iRubyObject3 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("freeze"))) != null) {
                this.freeze = iRubyObject3.isTrue();
            }
            if ((iRubyObject2 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("allow_unknown_ext"))) != null) {
                this.allowUnknownExt = iRubyObject2.isTrue();
            }
        }
        if (iRubyObject != null && iRubyObject != ruby.getNil()) {
            this.setStream(threadContext, iRubyObject);
        }
        return this;
    }

    public static Unpacker newUnpacker(ThreadContext threadContext, ExtensionRegistry extensionRegistry, IRubyObject[] iRubyObjectArray) {
        Unpacker unpacker = new Unpacker(threadContext.runtime, threadContext.runtime.getModule("MessagePack").getClass("Unpacker"), extensionRegistry);
        unpacker.initialize(threadContext, iRubyObjectArray);
        return unpacker;
    }

    @JRubyMethod(name={"symbolize_keys?"})
    public IRubyObject isSymbolizeKeys(ThreadContext threadContext) {
        return this.symbolizeKeys ? threadContext.runtime.getTrue() : threadContext.runtime.getFalse();
    }

    @JRubyMethod(name={"freeze?"})
    public IRubyObject isFreeze(ThreadContext threadContext) {
        return this.freeze ? threadContext.runtime.getTrue() : threadContext.runtime.getFalse();
    }

    @JRubyMethod(name={"allow_unknown_ext?"})
    public IRubyObject isAllowUnknownExt(ThreadContext threadContext) {
        return this.allowUnknownExt ? threadContext.runtime.getTrue() : threadContext.runtime.getFalse();
    }

    @JRubyMethod(name={"registered_types_internal"}, visibility=Visibility.PRIVATE)
    public IRubyObject registeredTypesInternal(ThreadContext threadContext) {
        return this.registry.toInternalUnpackerRegistry(threadContext);
    }

    @JRubyMethod(name={"register_type_internal"}, required=3, visibility=Visibility.PRIVATE)
    public IRubyObject registerTypeInternal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.testFrozen("MessagePack::Unpacker");
        Ruby ruby = threadContext.runtime;
        long l = ((RubyFixnum)iRubyObject).getLongValue();
        if (l < -128L || l > 127L) {
            throw ruby.newRangeError(String.format("integer %d too big to convert to `signed char'", l));
        }
        RubyModule rubyModule = null;
        if (iRubyObject2 != ruby.getNil()) {
            rubyModule = (RubyModule)iRubyObject2;
        }
        this.registry.put(rubyModule, (int)l, false, null, iRubyObject3);
        return ruby.getNil();
    }

    @JRubyMethod(required=2)
    public IRubyObject execute(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.executeLimit(threadContext, iRubyObject, iRubyObject2, null);
    }

    @JRubyMethod(name={"execute_limit"}, required=3)
    public IRubyObject executeLimit(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Decoder decoder;
        block3: {
            RubyString rubyString = iRubyObject.asString();
            int n = RubyNumeric.fix2int((IRubyObject)iRubyObject2);
            int n2 = iRubyObject3 == null || iRubyObject3.isNil() ? -1 : RubyNumeric.fix2int((IRubyObject)iRubyObject3);
            ByteList byteList = rubyString.getByteList();
            if (n2 == -1) {
                n2 = byteList.length() - n;
            }
            decoder = new Decoder(threadContext.runtime, this, byteList.unsafeBytes(), byteList.begin() + n, n2, this.symbolizeKeys, this.freeze, this.allowUnknownExt);
            try {
                this.data = null;
                this.data = decoder.next();
            }
            catch (RaiseException raiseException) {
                if (raiseException.getException().getType() == this.underflowErrorClass) break block3;
                throw raiseException;
            }
        }
        return threadContext.runtime.newFixnum(decoder.offset());
    }

    @JRubyMethod(name={"data"})
    public IRubyObject getData(ThreadContext threadContext) {
        if (this.data == null) {
            return threadContext.runtime.getNil();
        }
        return this.data;
    }

    @JRubyMethod(name={"finished?"})
    public IRubyObject finished_p(ThreadContext threadContext) {
        return this.data == null ? threadContext.runtime.getFalse() : threadContext.runtime.getTrue();
    }

    @JRubyMethod(required=1, name={"feed"}, alias={"feed_reference"})
    public IRubyObject feed(ThreadContext threadContext, IRubyObject iRubyObject) {
        ByteList byteList = iRubyObject.asString().getByteList();
        if (this.decoder == null) {
            this.decoder = new Decoder(threadContext.runtime, this, byteList.unsafeBytes(), byteList.begin(), byteList.length(), this.symbolizeKeys, this.freeze, this.allowUnknownExt);
        } else {
            this.decoder.feed(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
        return this;
    }

    @JRubyMethod(name={"full_unpack"})
    public IRubyObject fullUnpack(ThreadContext threadContext) {
        return this.decoder.next();
    }

    @JRubyMethod(name={"feed_each"}, required=1)
    public IRubyObject feedEach(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        this.feed(threadContext, iRubyObject);
        if (block.isGiven()) {
            this.each(threadContext, block);
            return threadContext.runtime.getNil();
        }
        return this.callMethod(threadContext, "to_enum");
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext threadContext, Block block) {
        if (block.isGiven()) {
            block5: {
                if (this.decoder != null) {
                    try {
                        while (this.decoder.hasNext()) {
                            block.yield(threadContext, this.decoder.next());
                        }
                    }
                    catch (RaiseException raiseException) {
                        if (raiseException.getException().getType() == this.underflowErrorClass) break block5;
                        throw raiseException;
                    }
                }
            }
            return this;
        }
        return this.callMethod(threadContext, "to_enum");
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext threadContext) {
        return threadContext.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject reset(ThreadContext threadContext) {
        if (this.decoder != null) {
            this.decoder.reset();
        }
        return threadContext.runtime.getNil();
    }

    @JRubyMethod(name={"read"}, alias={"unpack"})
    public IRubyObject read(ThreadContext threadContext) {
        if (this.decoder == null) {
            throw threadContext.runtime.newEOFError();
        }
        try {
            return this.decoder.next();
        }
        catch (RaiseException raiseException) {
            if (raiseException.getException().getType() != this.underflowErrorClass) {
                throw raiseException;
            }
            throw threadContext.runtime.newEOFError();
        }
    }

    @JRubyMethod(name={"skip"})
    public IRubyObject skip(ThreadContext threadContext) {
        throw threadContext.runtime.newNotImplementedError("Not supported yet in JRuby implementation");
    }

    @JRubyMethod(name={"skip_nil"})
    public IRubyObject skipNil(ThreadContext threadContext) {
        throw threadContext.runtime.newNotImplementedError("Not supported yet in JRuby implementation");
    }

    @JRubyMethod
    public IRubyObject read_array_header(ThreadContext threadContext) {
        if (this.decoder != null) {
            try {
                return this.decoder.read_array_header();
            }
            catch (RaiseException raiseException) {
                if (raiseException.getException().getType() != this.underflowErrorClass) {
                    throw raiseException;
                }
                throw threadContext.runtime.newEOFError();
            }
        }
        return threadContext.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject read_map_header(ThreadContext threadContext) {
        if (this.decoder != null) {
            try {
                return this.decoder.read_map_header();
            }
            catch (RaiseException raiseException) {
                if (raiseException.getException().getType() != this.underflowErrorClass) {
                    throw raiseException;
                }
                throw threadContext.runtime.newEOFError();
            }
        }
        return threadContext.runtime.getNil();
    }

    @JRubyMethod(name={"stream"})
    public IRubyObject getStream(ThreadContext threadContext) {
        if (this.stream == null) {
            return threadContext.runtime.getNil();
        }
        return this.stream;
    }

    @JRubyMethod(name={"stream="}, required=1)
    public IRubyObject setStream(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString;
        if (iRubyObject instanceof RubyIO) {
            rubyString = iRubyObject.callMethod(threadContext, "read").asString();
        } else if (iRubyObject.respondsTo("read")) {
            rubyString = iRubyObject.callMethod(threadContext, "read").asString();
        } else {
            throw threadContext.runtime.newTypeError(iRubyObject, "IO");
        }
        ByteList byteList = rubyString.getByteList();
        this.stream = iRubyObject;
        this.decoder = null;
        this.decoder = new Decoder(threadContext.runtime, this, byteList.unsafeBytes(), byteList.begin(), byteList.length(), this.symbolizeKeys, this.freeze, this.allowUnknownExt);
        return this.getStream(threadContext);
    }

    public ExtensionRegistry.ExtensionEntry lookupExtensionByTypeId(int n) {
        return this.registry.lookupExtensionByTypeId(n);
    }

    static class UnpackerAllocator
    implements ObjectAllocator {
        UnpackerAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Unpacker(ruby, rubyClass);
        }
    }
}

