/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import co.elastic.logstash.api.EventFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.logstash.Accessors;
import org.logstash.Cloner;
import org.logstash.ConvertedList;
import org.logstash.ConvertedMap;
import org.logstash.FieldReference;
import org.logstash.Javafier;
import org.logstash.ObjectMappers;
import org.logstash.RubyUtil;
import org.logstash.StringInterpolation;
import org.logstash.Timestamp;
import org.logstash.Util;
import org.logstash.Valuefier;
import org.logstash.ackedqueue.Queueable;
import org.logstash.ext.JrubyTimestampExtLibrary;
import org.logstash.plugins.BasicEventFactory;

public final class Event
implements Cloneable,
Queueable,
co.elastic.logstash.api.Event {
    private boolean cancelled;
    private ConvertedMap data;
    private ConvertedMap metadata;
    public static final String METADATA = "@metadata";
    public static final String METADATA_BRACKETS = "[@metadata]";
    public static final String TIMESTAMP = "@timestamp";
    public static final String TIMESTAMP_FAILURE_TAG = "_timestampparsefailure";
    public static final String TIMESTAMP_FAILURE_FIELD = "_@timestamp";
    public static final String VERSION = "@version";
    public static final String VERSION_ONE = "1";
    private static final String DATA_MAP_KEY = "DATA";
    private static final String META_MAP_KEY = "META";
    public static final String TAGS = "tags";
    public static final String TAGS_FAILURE_TAG = "_tagsparsefailure";
    public static final String TAGS_FAILURE = "_tags";
    private static final FieldReference TAGS_FIELD = FieldReference.from("tags");
    private static final FieldReference TAGS_FAILURE_FIELD = FieldReference.from("_tags");
    private static final Logger logger = LogManager.getLogger(Event.class);
    private static final Event[] NULL_ARRAY = new Event[0];

    public Event() {
        this.metadata = new ConvertedMap(10);
        this.data = new ConvertedMap(10);
        this.data.putInterned(VERSION, VERSION_ONE);
        this.cancelled = false;
        this.setTimestamp(Timestamp.now());
    }

    public Event(Map<? extends Serializable, Object> data) {
        this(ConvertedMap.newFromMap(data));
    }

    public Event(ConvertedMap data) {
        Object providedTimestamp;
        Timestamp parsedTimestamp;
        this.data = data;
        if (!this.data.containsKey(VERSION)) {
            this.data.putInterned(VERSION, VERSION_ONE);
        }
        this.metadata = this.data.containsKey(METADATA) ? ConvertedMap.newFromMap((Map)this.data.remove(METADATA)) : new ConvertedMap(10);
        this.cancelled = false;
        Object tags = Accessors.get(data, TAGS_FIELD);
        if (!this.isLegalTagValue(tags)) {
            this.initFailTag(tags);
            this.initTag(TAGS_FAILURE_TAG);
        }
        this.setTimestamp((parsedTimestamp = Event.initTimestamp(providedTimestamp = data.get(TIMESTAMP))) == null ? Timestamp.now() : parsedTimestamp);
        if (parsedTimestamp == null) {
            this.tag(TIMESTAMP_FAILURE_TAG);
            this.setField(TIMESTAMP_FAILURE_FIELD, providedTimestamp);
        }
    }

    public ConvertedMap getData() {
        return this.data;
    }

    public ConvertedMap getMetadata() {
        return this.metadata;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void uncancel() {
        this.cancelled = false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public Instant getEventTimestamp() {
        Timestamp t = this.getTimestamp();
        return t != null ? Instant.ofEpochMilli(t.toEpochMilli()) : null;
    }

    @Override
    public void setEventTimestamp(Instant timestamp) {
        this.setTimestamp(timestamp != null ? new Timestamp(timestamp.toEpochMilli()) : new Timestamp(Instant.now().toEpochMilli()));
    }

    public Timestamp getTimestamp() {
        JrubyTimestampExtLibrary.RubyTimestamp timestamp = (JrubyTimestampExtLibrary.RubyTimestamp)((Object)this.data.get(TIMESTAMP));
        return timestamp != null ? timestamp.getTimestamp() : null;
    }

    public void setTimestamp(Timestamp t) {
        this.data.putInterned(TIMESTAMP, (Object)JrubyTimestampExtLibrary.RubyTimestamp.newRubyTimestamp(RubyUtil.RUBY, t));
    }

    @Override
    public Object getField(String reference) {
        Object unconverted = this.getUnconvertedField(FieldReference.from(reference));
        return unconverted == null ? null : Javafier.deep(unconverted);
    }

    @Override
    public Object getUnconvertedField(String reference) {
        return this.getUnconvertedField(FieldReference.from(reference));
    }

    public Object getUnconvertedField(FieldReference field) {
        switch (field.type()) {
            case 0: {
                return this.metadata;
            }
            case 1: {
                return Accessors.get(this.metadata, field);
            }
        }
        return Accessors.get(this.data, field);
    }

    @Override
    public void setField(String reference, Object value) {
        this.setField(FieldReference.from(reference), value);
    }

    public void setField(FieldReference field, Object value) {
        if (field.equals(TAGS_FIELD) && !this.isLegalTagValue(value) || this.isTagsWithMap(field)) {
            throw new InvalidTagsTypeException(field, value);
        }
        switch (field.type()) {
            case 0: {
                this.metadata = ConvertedMap.newFromMap((Map)value);
                break;
            }
            case 1: {
                Accessors.set(this.metadata, field, Valuefier.convert(value));
                break;
            }
            default: {
                Accessors.set(this.data, field, Valuefier.convert(value));
            }
        }
    }

    private boolean isTagsWithMap(FieldReference field) {
        return field.getPath() != null && field.getPath().length > 0 && field.getPath()[0].equals(TAGS);
    }

    private boolean isLegalTagValue(Object value) {
        if (value instanceof String || value instanceof RubyString || value == null) {
            return true;
        }
        if (value instanceof List) {
            for (Object item : (List)value) {
                if (item instanceof String || item instanceof RubyString) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean includes(String field) {
        return this.includes(FieldReference.from(field));
    }

    public boolean includes(FieldReference field) {
        switch (field.type()) {
            case 0: {
                return true;
            }
            case 1: {
                return Accessors.includes(this.metadata, field);
            }
        }
        return Accessors.includes(this.data, field);
    }

    private static Event fromSerializableMap(byte[] source) throws IOException {
        Map representation = (Map)ObjectMappers.CBOR_MAPPER.readValue(source, ObjectMappers.EVENT_MAP_TYPE);
        if (representation == null) {
            throw new IOException("incompatible from binary object type only HashMap is supported");
        }
        Map dataMap = (Map)representation.get(DATA_MAP_KEY);
        if (dataMap == null) {
            throw new IOException("The deserialized Map must contain the \"DATA\" key");
        }
        Map metaMap = (Map)representation.get(META_MAP_KEY);
        if (metaMap == null) {
            throw new IOException("The deserialized Map must contain the \"META\" key");
        }
        dataMap.put(METADATA, metaMap);
        return new Event(dataMap);
    }

    public String toJson() throws JsonProcessingException {
        return ObjectMappers.JSON_MAPPER.writeValueAsString((Object)this.data);
    }

    private static Object parseJson(String json) throws IOException {
        return ObjectMappers.JSON_MAPPER.readValue(json, Object.class);
    }

    public static Event[] fromJson(String json) throws IOException {
        return Event.fromJson(json, BasicEventFactory.INSTANCE);
    }

    public static Event[] fromJson(String json, EventFactory factory) throws IOException {
        if (json == null || Event.isBlank(json)) {
            return NULL_ARRAY;
        }
        Object o = Event.parseJson(json);
        if (o instanceof Map) {
            return new Event[]{(Event)factory.newEvent((Map)o)};
        }
        if (o instanceof List) {
            return Event.fromList((List)o, factory);
        }
        throw new IOException("incompatible json object type=" + o.getClass().getName() + " , only hash map or arrays are supported");
    }

    private static Event[] fromList(List<Map<String, Object>> list, EventFactory factory) {
        int len = list.size();
        Event[] result = new Event[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (Event)factory.newEvent(list.get(i));
        }
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        return Cloner.deep(this.data);
    }

    @Override
    public co.elastic.logstash.api.Event overwrite(co.elastic.logstash.api.Event e) {
        if (e instanceof Event) {
            return this.overwrite((Event)e);
        }
        return e;
    }

    @Override
    public co.elastic.logstash.api.Event append(co.elastic.logstash.api.Event e) {
        if (e instanceof Event) {
            return this.append((Event)e);
        }
        return e;
    }

    public Event overwrite(Event e) {
        this.data = e.data;
        this.cancelled = e.cancelled;
        Timestamp t = e.getTimestamp();
        this.setTimestamp(t == null ? new Timestamp() : t);
        return this;
    }

    public Event append(Event e) {
        Util.mapMerge(this.data, e.data);
        return this;
    }

    @Override
    public Object remove(String path) {
        return this.remove(FieldReference.from(path));
    }

    public Object remove(FieldReference field) {
        switch (field.type()) {
            case 0: {
                ConvertedMap old_value = ConvertedMap.newFromMap(this.metadata);
                this.metadata = new ConvertedMap();
                return Javafier.deep(old_value);
            }
            case 1: {
                return Accessors.del(this.metadata, field);
            }
        }
        return Accessors.del(this.data, field);
    }

    @Override
    public String sprintf(String s) throws IOException {
        return StringInterpolation.evaluate(this, s);
    }

    @Override
    public Event clone() {
        ConvertedMap map = ConvertedMap.newFromMap(Cloner.deep(this.data));
        map.putInterned(METADATA, Cloner.deep(this.metadata));
        return new Event(map);
    }

    @Override
    public String toString() {
        Object hostField = this.getField("host");
        Object messageField = this.getField("message");
        String hostMessageString = (hostField != null ? hostField.toString() : "%{host}") + " " + (messageField != null ? messageField.toString() : "%{message}");
        Timestamp t = this.getTimestamp();
        return t != null ? t.toString() + " " + hostMessageString : hostMessageString;
    }

    private static boolean isBlank(String str) {
        int len = str.length();
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Timestamp initTimestamp(Object o) {
        if (o == null || o instanceof RubyNil) {
            return new Timestamp();
        }
        return Event.parseTimestamp(o);
    }

    private static Timestamp parseTimestamp(Object o) {
        try {
            if (o instanceof String) {
                return new Timestamp((String)o);
            }
            if (o instanceof RubyString) {
                return new Timestamp(o.toString());
            }
            if (o instanceof JrubyTimestampExtLibrary.RubyTimestamp) {
                return ((JrubyTimestampExtLibrary.RubyTimestamp)((Object)o)).getTimestamp();
            }
            if (o instanceof Timestamp) {
                return (Timestamp)o;
            }
            if (o instanceof DateTime) {
                return new Timestamp((DateTime)o);
            }
            if (o instanceof Date) {
                return new Timestamp((Date)o);
            }
            if (o instanceof RubySymbol) {
                return new Timestamp(((RubySymbol)o).asJavaString());
            }
            logger.warn("Unrecognized @timestamp value type=" + o.getClass().toString());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing @timestamp string value=" + o.toString());
        }
        return null;
    }

    @Override
    public void tag(String tag) {
        Object tags = Accessors.get(this.data, TAGS_FIELD);
        if (tags == null) {
            this.initTag(tag);
        } else {
            this.existingTag(Javafier.deep(tags), tag);
        }
    }

    private void initTag(String tag) {
        ConvertedList list = new ConvertedList(1);
        list.add(RubyUtil.RUBY.newString(tag));
        Accessors.set(this.data, TAGS_FIELD, list);
    }

    private void existingTag(Object tags, String tag) {
        if (tags instanceof List) {
            this.appendTag((List)tags, tag);
        } else {
            this.scalarTagFallback((String)tags, tag);
        }
    }

    private void appendTag(List<String> tags, String tag) {
        if (!tags.contains(tag)) {
            tags.add(tag);
            Accessors.set(this.data, TAGS_FIELD, ConvertedList.newFromList(tags));
        }
    }

    private void initFailTag(Object tag) {
        ConvertedList list = new ConvertedList(1);
        list.add(tag);
        Accessors.set(this.data, TAGS_FAILURE_FIELD, list);
    }

    private void scalarTagFallback(String existing, String tag) {
        ArrayList<String> tags = new ArrayList<String>(2);
        tags.add(existing);
        this.appendTag(tags, tag);
    }

    @Override
    public byte[] serialize() throws JsonProcessingException {
        HashMap<String, ConvertedMap> map = new HashMap<String, ConvertedMap>(2, 1.0f);
        map.put(DATA_MAP_KEY, this.data);
        map.put(META_MAP_KEY, this.metadata);
        return ObjectMappers.CBOR_MAPPER.writeValueAsBytes(map);
    }

    public static Event deserialize(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return new Event();
        }
        return Event.fromSerializableMap(data);
    }

    public long estimateMemory() {
        long total = 0L;
        total += this.data.estimateMemory();
        return total += this.metadata.estimateMemory();
    }

    public static class InvalidTagsTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidTagsTypeException(FieldReference field, Object value) {
            super(String.format("Could not set the reserved tags field '%s' to value '%s'. The tags field only accepts string or array of string.", InvalidTagsTypeException.getCanonicalFieldReference(field), value));
        }

        private static String getCanonicalFieldReference(FieldReference field) {
            ArrayList<String> path = new ArrayList<String>(List.of(field.getPath()));
            path.add(field.getKey());
            return path.stream().collect(Collectors.joining("][", "[", "]"));
        }
    }
}

