/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Javafier;
import org.logstash.RubyUtil;
import org.logstash.Valuefier;
import org.logstash.ext.JrubyTimestampExtLibrary;

public final class ConvertedMap
extends IdentityHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentHashMap<String, String> KEY_CACHE = new ConcurrentHashMap(100, 0.2f, 16);
    private static final RubyHash.VisitorWithState<ConvertedMap> RUBY_HASH_VISITOR = new RubyHash.VisitorWithState<ConvertedMap>(){

        public void visit(ThreadContext context, RubyHash self, IRubyObject key, IRubyObject value, int index, ConvertedMap state) {
            if (key instanceof RubyString) {
                state.putInterned(ConvertedMap.convertKey((RubyString)key), Valuefier.convert(value));
            } else {
                state.put(key.toString(), Valuefier.convert(value));
            }
        }
    };

    static String internStringForUseAsKey(String candidate) {
        String cached = KEY_CACHE.get(candidate);
        if (cached != null) {
            return cached;
        }
        String interned = candidate.intern();
        if (KEY_CACHE.size() <= 10000) {
            KEY_CACHE.put(interned, interned);
        }
        return interned;
    }

    static void internStringsForUseAsKeys(String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = ConvertedMap.internStringForUseAsKey(candidates[i]);
        }
    }

    ConvertedMap() {
        super(10);
    }

    ConvertedMap(int size) {
        super(size);
    }

    public static ConvertedMap newFromMap(Map<? extends Serializable, Object> o) {
        ConvertedMap cm = new ConvertedMap(o.size());
        for (Map.Entry<? extends Serializable, Object> entry : o.entrySet()) {
            Serializable found = entry.getKey();
            if (found instanceof String) {
                cm.put((String)((Object)found), Valuefier.convert(entry.getValue()));
                continue;
            }
            cm.putInterned(ConvertedMap.convertKey((RubyString)found), entry.getValue());
        }
        return cm;
    }

    public static ConvertedMap newFromRubyHash(RubyHash o) {
        return ConvertedMap.newFromRubyHash(RubyUtil.RUBY.getCurrentContext(), o);
    }

    public static ConvertedMap newFromRubyHash(ThreadContext context, RubyHash o) {
        ConvertedMap result = new ConvertedMap(o.size());
        o.visitAll(context, RUBY_HASH_VISITOR, (Object)result);
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(ConvertedMap.internStringForUseAsKey(key), value);
    }

    public void putInterned(String key, Object value) {
        super.put(key, value);
    }

    public Object unconvert() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            result.put((String)entry.getKey(), Javafier.deep(entry.getValue()));
        }
        return result;
    }

    private static String convertKey(RubyString key) {
        return ConvertedMap.internStringForUseAsKey(key.asJavaString());
    }

    public long estimateMemory() {
        return this.values().stream().map(this::estimateMemory).mapToLong(Long::longValue).sum();
    }

    private long estimateMemory(Object o) {
        if (o instanceof Boolean) {
            return 1L;
        }
        if (o instanceof Byte) {
            return 1L;
        }
        if (o instanceof Short) {
            return 2L;
        }
        if (o instanceof Integer) {
            return 4L;
        }
        if (o instanceof Long) {
            return 8L;
        }
        if (o instanceof Float) {
            return 4L;
        }
        if (o instanceof Double) {
            return 8L;
        }
        if (o instanceof Character) {
            return 2L;
        }
        if (o instanceof String) {
            return ((String)o).getBytes().length;
        }
        if (o instanceof RubyString) {
            return ((RubyString)o).getBytes().length;
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            long memory = 0L;
            for (Object v : c) {
                memory += this.estimateMemory(v);
            }
            return memory;
        }
        if (o instanceof ConvertedMap) {
            ConvertedMap c = (ConvertedMap)o;
            return c.estimateMemory();
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            long memory = 0L;
            for (Map.Entry e : m.entrySet()) {
                memory += this.estimateMemory(e.getKey());
                memory += this.estimateMemory(e.getValue());
            }
            return memory;
        }
        if (o instanceof JrubyTimestampExtLibrary.RubyTimestamp) {
            return 12L;
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).toByteArray().length;
        }
        if (o instanceof BigDecimal) {
            return 24L;
        }
        if (o instanceof RubyBignum) {
            RubyBignum rbn = (RubyBignum)o;
            return ((RubyFixnum)rbn.size()).getLongValue();
        }
        if (o instanceof RubyBigDecimal) {
            RubyBigDecimal rbd = (RubyBigDecimal)o;
            return this.estimateMemory(rbd.getValue());
        }
        if (o instanceof RubyFixnum) {
            return 4L;
        }
        if (o instanceof RubyBoolean) {
            return 1L;
        }
        if (o instanceof RubyNil) {
            return 12L;
        }
        if (o instanceof RubySymbol) {
            return this.estimateMemory(((RubySymbol)o).asJavaString());
        }
        if (o instanceof RubyFloat) {
            return 8L;
        }
        throw new IllegalArgumentException("Unsupported type encountered in estimateMemory: " + o.getClass().getName() + ". Please ensure all objects passed to estimateMemory are of supported types. Refer to the ConvertedMap.estimateMemory method for the list of supported types.");
    }
}

