/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.xml.util.Naming;
import org.relaxng.datatype.ValidationContext;

class QNameDatatype
extends DatatypeBase {
    QNameDatatype() {
    }

    @Override
    public boolean lexicallyAllows(String string) {
        return Naming.isQname(string);
    }

    @Override
    Object getValue(String string, ValidationContext validationContext) {
        int n = string.indexOf(58);
        if (n < 0) {
            String string2 = validationContext.resolveNamespacePrefix("");
            if (string2 == null) {
                string2 = "";
            }
            return new QName(string2, string);
        }
        String string3 = string.substring(0, n);
        String string4 = validationContext.resolveNamespacePrefix(string3);
        if (string4 == null) {
            return null;
        }
        return new QName(string4, string.substring(n + 1));
    }

    @Override
    boolean allowsValue(String string, ValidationContext validationContext) {
        int n = string.indexOf(58);
        return n < 0 || validationContext.resolveNamespacePrefix(string.substring(0, n)) != null;
    }

    @Override
    public boolean isContextDependent() {
        return true;
    }

    static class QName {
        private final String namespaceURI;
        private final String localName;

        QName(String string, String string2) {
            this.namespaceURI = string;
            this.localName = string2;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof QName)) {
                return false;
            }
            QName qName = (QName)object;
            return this.namespaceURI.equals(qName.namespaceURI) && this.localName.equals(qName.localName);
        }

        public int hashCode() {
            return this.localName.hashCode() ^ this.namespaceURI.hashCode();
        }
    }
}

