"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsUrl = exports.VIEW_ALERTS_LABEL = exports.AlertActions = exports.ACTIONS_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
var _alert_config = require("../../../../../../common/runtime_types/monitor_management/alert_config");
var _use_monitor_alert_enable = require("../../../hooks/use_monitor_alert_enable");
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _labels = require("../../monitors_page/management/monitor_list_table/labels");
var _contexts = require("../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/alert_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertActions = ({
  from,
  to
}) => {
  var _monitor$alert, _monitor$alert$status;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const monitorQueryId = (0, _use_monitor_query_id.useMonitorQueryId)();
  const {
    alertStatus,
    updateAlertEnabledState
  } = (0, _use_monitor_alert_enable.useMonitorAlertEnable)();
  const alertsUrl = useAlertsUrl({
    rangeFrom: from,
    rangeTo: to,
    monitorId: monitorQueryId
  });
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const isActionLoading = configId => {
    return alertStatus(configId) === _public.FETCH_STATUS.LOADING;
  };
  if (!monitor) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 12
      }
    });
  }
  const onToggleAlertClick = () => {
    updateAlertEnabledState({
      monitor: {
        [_runtime_types.ConfigKey.ALERT_CONFIG]: (0, _alert_config.toggleStatusAlert)(monitor[_runtime_types.ConfigKey.ALERT_CONFIG])
      },
      name: monitor[_runtime_types.ConfigKey.NAME],
      configId: monitor[_runtime_types.ConfigKey.CONFIG_ID]
    });
  };
  const isAlertEnabled = (_monitor$alert = monitor.alert) === null || _monitor$alert === void 0 ? void 0 : (_monitor$alert$status = _monitor$alert.status) === null || _monitor$alert$status === void 0 ? void 0 : _monitor$alert$status.enabled;
  const isLoading = isActionLoading(monitor[_runtime_types.ConfigKey.CONFIG_ID]);
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "edit",
    icon: isAlertEnabled ? 'bellSlash' : 'bell',
    onClick: onToggleAlertClick,
    disabled: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, isAlertEnabled ? _labels.DISABLE_STATUS_ALERT : _labels.ENABLE_STATUS_ALERT, ' ', isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "share",
    icon: "list",
    href: alertsUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, VIEW_ALERTS_LABEL)];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsAlertActionsButton",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, ACTIONS_LABEL);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "monitorAlertActionsContext",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }));
};
exports.AlertActions = AlertActions;
const useAlertsUrl = ({
  rangeFrom,
  rangeTo,
  monitorId
}) => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  let kuery = 'kibana.alert.rule.category : "Synthetics monitor status" ';
  if (monitorId) {
    kuery += `AND monitor.id : "${monitorId}"`;
  }
  return `${basePath}/app/observability/alerts?_a=${_rison.default.encode({
    kuery,
    rangeFrom,
    rangeTo
  })}`;
};
exports.useAlertsUrl = useAlertsUrl;
const ACTIONS_LABEL = exports.ACTIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.actions', {
  defaultMessage: 'Actions'
});
const VIEW_ALERTS_LABEL = exports.VIEW_ALERTS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.actions.viewAlerts', {
  defaultMessage: 'View alerts'
});