"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusCellTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var labels = _interopRequireWildcard(require("./labels"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_status/monitor_status_cell_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorStatusCellTooltip = ({
  timeBin,
  isLoading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;
  const SUCCESS_COLOR = isAmsterdam ? _eui.VISUALIZATION_COLORS[0] : euiTheme.colors.success;
  const DANGER_COLOR = isAmsterdam ? _eui.VISUALIZATION_COLORS[_eui.VISUALIZATION_COLORS.length - 1] : euiTheme.colors.danger;
  if (!timeBin) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '');
  }
  const startM = (0, _moment.default)(timeBin.start);
  const endM = (0, _moment.default)(timeBin.end);
  const startDateStr = startM.format('LL');
  const timeStartStr = startM.format('HH:mm');
  const timeEndStr = endM.format('HH:mm');
  const isDifferentDays = startM.dayOfYear() !== endM.dayOfYear();

  // If start and end days are different, show date for both of the days
  const endDateSegment = isDifferentDays ? `${endM.format('LL')} @ ` : '';
  const tooltipTitle = `${startDateStr} @ ${timeStartStr} - ${endDateSegment}${timeEndStr}`;
  const availabilityStr = timeBin.ups + timeBin.downs > 0 ? `${Math.round(timeBin.ups / (timeBin.ups + timeBin.downs) * 100)}%` : '-';

  // not currently used but required by current types
  const commonTooltipValuesProps = {
    isVisible: true,
    isHighlighted: false,
    seriesIdentifier: {
      specId: '',
      key: ''
    }
  };
  const tooltipValues = isLoading ? [] : [{
    color: 'transparent',
    label: labels.AVAILABILITY_LABEL,
    value: availabilityStr,
    formattedValue: availabilityStr,
    ...commonTooltipValuesProps
  }, {
    color: SUCCESS_COLOR,
    label: labels.COMPLETE_LABEL,
    value: timeBin.ups,
    formattedValue: `${timeBin.ups}`,
    ...commonTooltipValuesProps
  }, {
    color: DANGER_COLOR,
    label: labels.FAILED_LABEL,
    value: timeBin.downs,
    formattedValue: `${timeBin.downs}`,
    ...commonTooltipValuesProps
  }];
  return /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, tooltipTitle), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTable, {
    columns: [{
      type: 'color'
    }, {
      type: 'text',
      cell: t => t.label,
      style: {
        textAlign: 'left'
      }
    }, {
      type: 'number',
      cell: t => t.value,
      style: {
        textAlign: 'right'
      }
    }],
    items: tooltipValues,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};
exports.MonitorStatusCellTooltip = MonitorStatusCellTooltip;