"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Field = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _state = require("../../../state");
var _hooks = require("../hooks");
var _controlled_field = require("./controlled_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/form/field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Field = exports.Field = /*#__PURE__*/(0, _react.memo)(({
  component: Component,
  helpText,
  label,
  labelAppend,
  ariaLabel,
  props,
  fieldKey,
  controlled,
  required,
  validation,
  error: validationError,
  fieldError,
  dependencies,
  customHook,
  hidden
}) => {
  const {
    register,
    control,
    setValue,
    reset,
    formState,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const {
    space
  } = (0, _hooks.useKibanaSpace)();
  const isEdit = (0, _hooks.useIsEditFlow)();
  const {
    dependenciesValues,
    dependenciesFieldMeta,
    error,
    isInvalid,
    rules
  } = (0, _hooks.useValidateField)({
    fieldKey,
    validation,
    dependencies,
    required: required !== null && required !== void 0 ? required : false,
    customHook,
    validationError
  });
  if (hidden && hidden(dependenciesValues)) {
    return null;
  }
  const formRowProps = {
    label,
    'aria-label': ariaLabel,
    helpText,
    fullWidth: true,
    labelAppend
  };
  return controlled ? /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: fieldKey,
    rules: rules,
    render: ({
      field,
      fieldState: fieldStateT
    }) => {
      return /*#__PURE__*/_react.default.createElement(_controlled_field.ControlledField, {
        field: field,
        component: Component,
        props: props,
        fieldKey: fieldKey,
        formRowProps: formRowProps,
        fieldState: fieldStateT,
        error: error,
        isInvalid: isInvalid,
        dependenciesValues: dependenciesValues,
        dependenciesFieldMeta: dependenciesFieldMeta,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 13
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
    isInvalid: Boolean(fieldError),
    error: (fieldError === null || fieldError === void 0 ? void 0 : fieldError.message) || error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, register(fieldKey, rules), props ? props({
    field: undefined,
    formState,
    setValue,
    trigger,
    reset,
    locations: locations.map(location => ({
      ...location,
      key: location.id
    })),
    dependencies: dependenciesValues,
    dependenciesFieldMeta,
    space: space === null || space === void 0 ? void 0 : space.id,
    isEdit
  }) : {}, {
    isInvalid: isInvalid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })));
});