"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSONEditor = exports.CodeEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _useThrottle = _interopRequireDefault(require("react-use/lib/useThrottle"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _codeEditor = require("@kbn/code-editor");
var _types = require("../types");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/code_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CodeEditorContainer = (0, _styledComponents.default)(_eui.EuiPanel)`
  padding: 0;
`;
const CodeEditor = ({
  ariaLabel,
  id,
  languageId,
  onChange,
  value,
  placeholder,
  height = '250px',
  readOnly
}) => {
  const {
    elementRef: containerRef,
    width: containerWidth
  } = (0, _hooks.useDimensions)();
  const containerWidthThrottled = (0, _useThrottle.default)(containerWidth, 500);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CodeEditorContainer, {
    panelRef: containerRef,
    borderRadius: "none",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(MonacoCodeContainer, {
    id: `${id}-editor`,
    "aria-label": ariaLabel,
    "data-test-subj": "codeEditorContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: languageId,
    width: containerWidthThrottled !== null && containerWidthThrottled !== void 0 ? containerWidthThrottled : '100%',
    height: height,
    value: value,
    onChange: onChange,
    options: {
      renderValidationDecorations: value ? 'on' : 'off',
      readOnly
    },
    isCopyable: true,
    allowFullScreen: true,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }))));
};
exports.CodeEditor = CodeEditor;
const MonacoCodeContainer = _common.euiStyled.div`
  & > .kibanaCodeEditor {
    z-index: 0;
  }
`;
const JSONEditor = props => {
  return /*#__PURE__*/_react.default.createElement(CodeEditor, (0, _extends2.default)({
    languageId: _types.MonacoEditorLangId.JSON
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 10
    }
  }));
};
exports.JSONEditor = JSONEditor;