"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useErrorFailedTests = useErrorFailedTests;
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
var _client_defaults = require("../../../../../../common/constants/client_defaults");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useErrorFailedTests() {
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    errorStateId,
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    data,
    loading
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    size: 10000,
    query: {
      bool: {
        filter: [_client_defaults.SUMMARY_FILTER, _client_defaults.EXCLUDE_RUN_ONCE_FILTER, {
          term: {
            'state.id': errorStateId
          }
        }, {
          term: {
            config_id: monitorId
          }
        }]
      }
    },
    sort: [{
      '@timestamp': 'desc'
    }]
  }, [lastRefresh, monitorId, dateRangeStart, dateRangeEnd], {
    name: 'getMonitorErrorFailedTests'
  });
  return (0, _react.useMemo)(() => {
    var _data$hits$hits$map, _data$hits$hits;
    const failedTests = (_data$hits$hits$map = data === null || data === void 0 ? void 0 : (_data$hits$hits = data.hits.hits) === null || _data$hits$hits === void 0 ? void 0 : _data$hits$hits.map(doc => {
      const source = doc._source;
      return {
        ...source,
        timestamp: source['@timestamp']
      };
    })) !== null && _data$hits$hits$map !== void 0 ? _data$hits$hits$map : [];
    return {
      failedTests,
      loading
    };
  }, [data, loading]);
}