"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTypeBadge = MonitorTypeBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _runtime_types = require("../../../../../../common/runtime_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/monitor_type_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MonitorTypeBadge({
  monitorType,
  ariaLabel,
  onClick
}) {
  return onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: onClick,
    onClickAriaLabel: getFilterTitle(monitorType),
    title: ariaLabel,
    "aria-label": ariaLabel,
    iconType: getMonitorTypeBadgeIcon(monitorType),
    onMouseDown: e => {
      // Prevents the click event from being propagated to the @elastic/chart metric
      e.stopPropagation();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, getMonitorTypeBadgeTitle(monitorType)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: ariaLabel,
    "aria-label": ariaLabel,
    iconType: getMonitorTypeBadgeIcon(monitorType),
    onMouseDown: e => {
      // Prevents the click event from being propagated to the @elastic/chart metric
      e.stopPropagation();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, getMonitorTypeBadgeTitle(monitorType));
}
const getFilterTitle = type => {
  return _i18n.i18n.translate('xpack.synthetics.management.monitorList.monitorTypeBadge.filter', {
    defaultMessage: 'Click to filter monitors for type: {type}',
    values: {
      type: getMonitorTypeBadgeTitle(type)
    }
  });
};
function getMonitorTypeBadgeTitle(monitorType) {
  switch (monitorType) {
    case _runtime_types.FormMonitorType.TCP:
    case _runtime_types.FormMonitorType.HTTP:
    case _runtime_types.FormMonitorType.ICMP:
      return monitorType.toUpperCase();
    case _runtime_types.FormMonitorType.SINGLE:
      return 'Page';
    case _runtime_types.FormMonitorType.MULTISTEP:
      return 'Journey';
  }
  switch (monitorType) {
    case _runtime_types.MonitorTypeEnum.BROWSER:
      return 'Journey';
    default:
      return monitorType.toUpperCase();
  }
}
function getMonitorTypeBadgeIcon(monitorType) {
  return monitorType === 'browser' ? 'videoPlayer' : 'online';
}