"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_CODE_LABEL = exports.MonitorInspect = exports.INSPECT_MONITOR_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsYaml = _interopRequireDefault(require("js-yaml"));
var _contexts = require("../../../contexts");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _runtime_types = require("../../../../../../common/runtime_types");
var _api = require("../../../state/monitor_management/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/monitor_inspect.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorInspect = ({
  isValid,
  monitorFields
}) => {
  const {
    isDev
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const [hideParams, setHideParams] = (0, _react.useState)(() => !isDev);
  const [asJson, setAsJson] = (0, _react.useState)(false);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const closeFlyout = () => {
    setIsFlyoutVisible(false);
    setIsInspecting(false);
  };
  const [isInspecting, setIsInspecting] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsInspecting(() => !isInspecting);
    setIsFlyoutVisible(() => !isFlyoutVisible);
  };
  const {
    data,
    loading,
    error
  } = (0, _public.useFetcher)(() => {
    if (isInspecting) {
      return (0, _api.inspectMonitorAPI)({
        hideParams,
        monitor: monitorFields
      });
    }
    // FIXME: Dario couldn't find a solution for monitorFields
    // which is not memoized downstream
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isInspecting, hideParams]);
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      onClose: closeFlyout,
      "aria-labelledby": "flyoutTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "flyoutTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }, CONFIG_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      compressed: true,
      label: HIDE_PARAMS,
      checked: hideParams,
      onChange: e => setHideParams(e.target.checked),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      compressed: true,
      label: AS_JSON,
      checked: asJson,
      onChange: e => setAsJson(e.target.checked),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }), !loading && data ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: asJson ? 'json' : 'yaml',
      fontSize: "m",
      paddingSize: "m",
      lineNumbers: true,
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 15
      }
    }, formatContent(data.result, asJson)), data.decodedCode && /*#__PURE__*/_react.default.createElement(MonitorCode, {
      code: data.decodedCode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 36
      }
    })) : loading && !error ? /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 13
      }
    }, error === null || error === void 0 ? void 0 : error.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsMonitorInspectCloseButton",
      onClick: closeFlyout,
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }, CLOSE_LABEL)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isValid ? FORMATTED_CONFIG_DESCRIPTION : VALID_CONFIG_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !isValid,
    "data-test-subj": "syntheticsMonitorInspectShowFlyoutExampleButton",
    onClick: onButtonClick,
    iconType: "inspect",
    iconSide: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, INSPECT_MONITOR_LABEL)), flyout);
};

// @ts-ignore: Unused variable
// tslint:disable-next-line: no-unused-variable
exports.MonitorInspect = MonitorInspect;
const MonitorCode = ({
  code
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 156,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 157,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "flyoutTitle",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 158,
    columnNumber: 7
  }
}, SOURCE_CODE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 160,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "javascript",
  fontSize: "m",
  paddingSize: "m",
  lineNumbers: true,
  isCopyable: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 161,
    columnNumber: 5
  }
}, code));
const formatContent = (result, asJson) => {
  var _result$publicConfigs, _result$publicConfigs2, _result$publicConfigs3, _result$privateConfig, _currentInput$streams;
  const firstResult = (_result$publicConfigs = result.publicConfigs) === null || _result$publicConfigs === void 0 ? void 0 : (_result$publicConfigs2 = _result$publicConfigs[0]) === null || _result$publicConfigs2 === void 0 ? void 0 : (_result$publicConfigs3 = _result$publicConfigs2.monitors) === null || _result$publicConfigs3 === void 0 ? void 0 : _result$publicConfigs3[0];
  const currentInput = (_result$privateConfig = result.privateConfig) === null || _result$privateConfig === void 0 ? void 0 : _result$privateConfig.inputs.find(input => input.enabled);
  const compiledConfig = currentInput === null || currentInput === void 0 ? void 0 : (_currentInput$streams = currentInput.streams.find(stream => Object.values(_runtime_types.MonitorTypeEnum).includes(stream.data_stream.dataset))) === null || _currentInput$streams === void 0 ? void 0 : _currentInput$streams.compiled_stream;
  const data = {
    publicConfig: firstResult !== null && firstResult !== void 0 ? firstResult : {},
    privateConfig: compiledConfig !== null && compiledConfig !== void 0 ? compiledConfig : {}
  };
  if (!asJson) {
    return _jsYaml.default.dump(data);
  }
  return JSON.stringify(data, null, 2);
};
const CONFIG_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.configLabel', {
  defaultMessage: 'Configuration'
});
const VALID_CONFIG_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.formattedConfigLabel.valid', {
  defaultMessage: 'Only valid form configurations can be inspected.'
});
const FORMATTED_CONFIG_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorInspect.formattedConfigLabel.description', {
  defaultMessage: 'View formatted configuration for this monitor.'
});
const CLOSE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.closeLabel', {
  defaultMessage: 'Close'
});
const SOURCE_CODE_LABEL = exports.SOURCE_CODE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.sourceCodeLabel', {
  defaultMessage: 'Source code'
});
const INSPECT_MONITOR_LABEL = exports.INSPECT_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.inspectLabel', {
  defaultMessage: 'Inspect configuration'
});
const HIDE_PARAMS = _i18n.i18n.translate('xpack.synthetics.monitorInspect.hideParams', {
  defaultMessage: 'Hide parameter values'
});
const AS_JSON = _i18n.i18n.translate('xpack.synthetics.monitorInspect.asJson', {
  defaultMessage: 'As JSON'
});