"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSearchBar = AlertSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _synthetics_data_view_context = require("../../contexts/synthetics_data_view_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/query_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AlertSearchBar({
  kqlQuery,
  onChange,
  filtersForSuggestions
}) {
  const {
    data: {
      query
    },
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = (0, _public.useKibana)().services;
  const dataView = (0, _synthetics_data_view_context.useSyntheticsDataView)();
  (0, _react.useEffect)(() => {
    const sub = query.state$.subscribe(() => {
      const queryState = query.getState();
      onChange({
        kqlQuery: String(queryState.query)
      });
    });
    return () => sub.unsubscribe();
  }, [onChange, query]);
  if (!dataView) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.synthetics.list.search.title', {
      defaultMessage: 'Filter by'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    appName: "synthetics",
    iconType: "search",
    placeholder: PLACEHOLDER,
    indexPatterns: [dataView],
    onChange: queryN => {
      onChange({
        kqlQuery: String(queryN.query)
      });
    },
    onSubmit: queryN => {
      if (queryN) {
        onChange({
          kqlQuery: String(queryN.query)
        });
      }
    },
    query: {
      query: String(kqlQuery),
      language: 'kuery'
    },
    autoSubmit: true,
    disableLanguageSwitcher: true,
    filtersForSuggestions: filtersForSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
}
const PLACEHOLDER = _i18n.i18n.translate('xpack.synthetics.list.search', {
  defaultMessage: 'Filter by KQL query'
});