"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSyntheticsSuggestions = useFetchSyntheticsSuggestions;
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSyntheticsSuggestions({
  filters,
  fieldName,
  search
}) {
  var _data$fieldName;
  const {
    http
  } = (0, _public.useKibana)().services;
  const {
    locations,
    monitorIds,
    tags,
    projects,
    monitorTypes
  } = filters || {};
  const {
    loading,
    data
  } = (0, _public2.useFetcher)(async ({
    signal
  }) => {
    return await http.get('/internal/synthetics/suggestions', {
      query: {
        locations: locations || [],
        monitorQueryIds: monitorIds || [],
        tags: tags || [],
        projects: projects || [],
        monitorTypes: monitorTypes || [],
        query: search
      },
      signal
    });
  }, [http, locations, monitorIds, tags, projects, search, monitorTypes]);
  return {
    suggestions: fieldName ? (_data$fieldName = data === null || data === void 0 ? void 0 : data[fieldName]) !== null && _data$fieldName !== void 0 ? _data$fieldName : [] : [],
    allSuggestions: data,
    isLoading: Boolean(loading)
  };
}