"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelector = FieldSelector;
exports.onFieldChange = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sloSchema = require("@kbn/slo-schema");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/common/field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ALL_OPTION = {
  label: _i18n.i18n.translate('xpack.synthetics.filter.alert.allLabel', {
    defaultMessage: 'All'
  }),
  value: _sloSchema.ALL_VALUE
};
function FieldSelector({
  allowAllOption = true,
  dataTestSubj,
  value,
  onChange,
  isLoading,
  placeholder,
  suggestions,
  setSearch
}) {
  const options = (allowAllOption ? [ALL_OPTION] : []).concat(createOptions(suggestions));
  const debouncedSearch = (0, _lodash.debounce)(val => setSearch(val), 200);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    placeholder: placeholder,
    "data-test-subj": dataTestSubj,
    isClearable: true,
    fullWidth: true,
    isLoading: isLoading,
    onChange: selected => {
      onFieldChange(selected, onChange);
    },
    onSearchChange: val => debouncedSearch(val),
    options: options,
    selectedOptions: value === null || value === void 0 ? void 0 : value.map(val => {
      const option = options.find(opt => opt.value === val);
      if (option) {
        return {
          value: val,
          label: option.label,
          'data-test-subj': `${dataTestSubj}SelectedValue`
        };
      }
      return {
        value: val,
        label: val,
        'data-test-subj': `${dataTestSubj}SelectedValue`
      };
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
}
const onFieldChange = (selected, onChange) => {
  var _selected$at, _selected$at2;
  // removes ALL value option if a specific value is selected
  if (selected.length && ((_selected$at = selected.at(-1)) === null || _selected$at === void 0 ? void 0 : _selected$at.value) !== _sloSchema.ALL_VALUE) {
    onChange(selected.filter(val => val.value !== _sloSchema.ALL_VALUE).map(val => val.value));
    return;
  }
  // removes specific value if ALL value is selected
  if (selected.length && ((_selected$at2 = selected.at(-1)) === null || _selected$at2 === void 0 ? void 0 : _selected$at2.value) === _sloSchema.ALL_VALUE) {
    onChange([]);
    return;
  }
  onChange([]);
};
exports.onFieldChange = onFieldChange;
function createOptions(suggestions = []) {
  return suggestions.map(suggestion => ({
    label: suggestion.label,
    value: suggestion.value
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}