"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectMonitorsResponseCodec = exports.ProjectMonitorsRequestCodec = exports.ProjectMonitorThrottlingConfigCodec = exports.ProjectMonitorMetaDataCodec = exports.ProjectMonitorCodec = exports.LegacyProjectMonitorsRequestCodec = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _alert_config = require("./alert_config");
var _monitor_configs = require("./monitor_configs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProjectMonitorSchedule = new t.Type('ProjectMonitorSchedule', t.string.is, (input, context) => {
  if (typeof input === 'number' || input === '10s' || input === '30s') {
    return t.success(input);
  } else {
    return t.failure(input, context);
  }
}, t.identity);
const ProjectMonitorThrottlingConfigCodec = exports.ProjectMonitorThrottlingConfigCodec = t.union([t.interface({
  download: t.number,
  upload: t.number,
  latency: t.number
}), t.boolean]);
const ProjectMonitorCodec = exports.ProjectMonitorCodec = t.intersection([t.interface({
  type: t.string,
  id: t.string,
  name: t.string,
  schedule: ProjectMonitorSchedule
}), t.partial({
  content: t.string,
  timeout: t.string,
  privateLocations: t.array(t.string),
  locations: t.array(t.string),
  throttling: ProjectMonitorThrottlingConfigCodec,
  screenshot: _monitor_configs.ScreenshotOptionCodec,
  tags: t.union([t.string, t.array(t.string)]),
  ignoreHTTPSErrors: t.boolean,
  playwrightOptions: t.record(t.string, t.unknown),
  filter: t.interface({
    match: t.string
  }),
  params: t.record(t.string, t.unknown),
  enabled: t.boolean,
  alert: _alert_config.AlertConfigsCodec,
  urls: t.union([t.string, t.array(t.string)]),
  hosts: t.union([t.string, t.array(t.string)]),
  max_redirects: t.union([t.string, t.number]),
  wait: t.string,
  hash: t.string,
  namespace: t.string,
  retestOnFailure: t.boolean,
  fields: t.record(t.string, t.string),
  'service.name': t.string,
  maintenanceWindows: t.array(t.string),
  spaces: t.array(t.string)
})]);
const ProjectMonitorsRequestCodec = exports.ProjectMonitorsRequestCodec = t.interface({
  monitors: t.array(ProjectMonitorCodec)
});
const LegacyProjectMonitorsRequestCodec = exports.LegacyProjectMonitorsRequestCodec = t.interface({
  project: t.string,
  keep_stale: t.boolean,
  monitors: t.array(ProjectMonitorCodec)
});
const ProjectMonitorMetaDataCodec = exports.ProjectMonitorMetaDataCodec = t.interface({
  hash: t.string,
  journey_id: t.string
});
const ProjectMonitorsResponseCodec = exports.ProjectMonitorsResponseCodec = t.intersection([t.interface({
  total: t.number,
  monitors: t.array(ProjectMonitorMetaDataCodec)
}), t.partial({
  after_key: t.string
})]);