"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConditionType = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConditionType = condition => {
  var _condition$locationsT, _condition$downThresh2;
  let numberOfChecks = 1;
  let timeWindow = {
    unit: 'm',
    size: 1
  };
  if ((0, _lodash.isEmpty)(condition) || !(condition !== null && condition !== void 0 && condition.window)) {
    return {
      isLocationBased: false,
      useTimeWindow: false,
      timeWindow,
      useLatestChecks: true,
      numberOfChecks,
      downThreshold: 1,
      locationsThreshold: 1,
      isDefaultRule: true
    };
  }
  const useTimeWindow = condition.window && 'time' in condition.window;
  const useLatestChecks = condition.window && 'numberOfChecks' in condition.window;
  if (useLatestChecks) {
    numberOfChecks = condition && 'numberOfChecks' in condition.window ? condition.window.numberOfChecks : 1;
  }
  if (useTimeWindow) {
    var _condition$downThresh;
    timeWindow = condition.window.time;
    numberOfChecks = (_condition$downThresh = condition === null || condition === void 0 ? void 0 : condition.downThreshold) !== null && _condition$downThresh !== void 0 ? _condition$downThresh : 1;
  }
  return {
    useTimeWindow,
    timeWindow,
    useLatestChecks,
    numberOfChecks,
    locationsThreshold: (_condition$locationsT = condition === null || condition === void 0 ? void 0 : condition.locationsThreshold) !== null && _condition$locationsT !== void 0 ? _condition$locationsT : 1,
    downThreshold: (_condition$downThresh2 = condition === null || condition === void 0 ? void 0 : condition.downThreshold) !== null && _condition$downThresh2 !== void 0 ? _condition$downThresh2 : 1,
    isDefaultRule: (0, _lodash.isEmpty)(condition)
  };
};
exports.getConditionType = getConditionType;