"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_NESTING_LEVEL = void 0;
exports.getAncestors = getAncestors;
exports.getAncestorsAndSelf = getAncestorsAndSelf;
exports.getParentId = getParentId;
exports.getRoot = getRoot;
exports.getSegments = getSegments;
exports.isChildOf = isChildOf;
exports.isDescendantOf = isDescendantOf;
exports.isRoot = isRoot;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isDescendantOf(parent, child) {
  return child.startsWith(parent + '.');
}
function isChildOf(parent, child) {
  return isDescendantOf(parent, child) && child.split('.').length === parent.split('.').length + 1;
}
function getParentId(id) {
  const parts = id.split('.');
  if (parts.length === 1) {
    return undefined;
  }
  return parts.slice(0, parts.length - 1).join('.');
}
function isRoot(id) {
  return id.split('.').length === 1;
}
function getAncestors(id) {
  const parts = id.split('.');
  return parts.slice(0, parts.length - 1).map((_, index) => parts.slice(0, index + 1).join('.'));
}
function getRoot(id) {
  return id.split('.')[0];
}
function getAncestorsAndSelf(id) {
  return getAncestors(id).concat(id);
}
function getSegments(id) {
  return id.split('.');
}
const MAX_NESTING_LEVEL = exports.MAX_NESTING_LEVEL = 5;